/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysCompanyPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.CompanyServiceRpc;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.po.CouponManualPO;
import com.bizvane.couponfacade.models.vo.CouponDifindustryQuantityRecordVO;
import com.bizvane.couponfacade.models.vo.CouponFindCouponCountResponseVO;
import com.bizvane.couponservice.common.datavo.BitDataRequestVO;
import com.bizvane.couponservice.common.datavo.BitDataVO;
import com.bizvane.couponservice.common.datavo.SalesNumVO;
import com.bizvane.couponservice.common.utils.BaseData;
import com.bizvane.couponservice.common.utils.BaseUrl;
import com.bizvane.couponservice.common.utils.HttpUtils;
import com.bizvane.couponservice.service.BitDataAnalysisService;
import com.bizvane.couponservice.service.CouponDifindustryQuantityRecordService;
import com.bizvane.couponservice.service.CouponManualService;
import com.bizvane.couponservice.service.CouponService;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/bitDataAnalysis"})
public class BitDataAnalysisController {
    private static final Logger logger = LoggerFactory.getLogger(BitDataAnalysisController.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BaseUrl baseUrl;
    @Autowired
    private BitDataAnalysisService bitDataAnalysisService;
    @Autowired
    private CompanyServiceRpc companyServiceRpc;
    @Autowired
    private CouponService couponService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private CouponManualService couponManualService;
    @Autowired
    private CouponDifindustryQuantityRecordService couponDifindustryQuantityRecordService;
    private final String ONE = "1";

    @ApiOperation(value="\u53d1\u9001\u7684\u4f18\u60e0\u5238\uff1a", notes="\u53d1\u9001\u7684\u4f18\u60e0\u5238\uff1a", tags={"\u624b\u52a8\u53d1\u5238\u7ed3\u679c\u5206\u6790"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponManualId", value="\u624b\u5de5\u53d1\u5238id", required=true, dataType="Integer")})
    @PostMapping(value={"/bitDataAnalysis"})
    ResponseData<BitDataRequestVO> bitDataAnalysis(BitDataVO vo, HttpServletRequest request) {
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        return this.bitDataAnalysisService.getCouponQuotaAnalysisDetail(vo, accountPo);
    }

    @ApiOperation(value="\u5238\u4efb\u52a1\u5206\u6790", notes="\u5238\u4efb\u52a1\u5206\u6790", tags={"\u5238\u4efb\u52a1\u5206\u6790"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="batchNo", value="batchNo", required=true, dataType="batchNo")})
    @PostMapping(value={"vouTaskAnalysis"})
    public ResponseData<JSONObject> vouTaskAnalysis(BitDataVO sendVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        JSONObject backJsonObject = new JSONObject();
        for (String key : "achievements,pieceNumber,penNumber,discount,orderNum".split(",")) {
            backJsonObject.put(key, (Object)"0");
        }
        responseData = this.backJsonObject(JSONObject.parseObject((String)JSONObject.toJSONString((Object)sendVO)), backJsonObject, this.baseUrl.getLoadUrl("vouTaskAnalysis"), request);
        JSONObject jsonObject = (JSONObject)responseData.getData();
        CouponManualPO couponManualPo = this.couponManualService.getCouponManualPoById(sendVO.getCouponManualId());
        if (Integer.valueOf(SendTypeEnum.SEND_COUPON_DIF.getCode()).equals(couponManualPo.getCouponType())) {
            SysAccountPO sysAccountPo = new SysAccountPO();
            BeanUtils.copyProperties((Object)accountPo, (Object)sysAccountPo);
            ResponseData recordVOResponseData = this.couponDifindustryQuantityRecordService.selectByManualId(couponManualPo.getCouponManualId(), sysAccountPo);
            CouponDifindustryQuantityRecordVO data = (CouponDifindustryQuantityRecordVO)recordVOResponseData.getData();
            Integer totalQuantiy = data.getTotalQuantiy();
            Integer useQuantiy = data.getUseQuantiy();
            jsonObject.put("totalQuantiy", (Object)totalQuantiy);
            jsonObject.put("useQuantiy", (Object)useQuantiy);
        }
        CouponFindCouponCountResponseVO couponFindCouponCountResponseVO = this.couponService.findCouponCountbatchSend(Long.valueOf(sendVO.getBatchNo()), null, null, null);
        jsonObject.put("couponSum", (Object)couponFindCouponCountResponseVO.getCouponSum());
        jsonObject.put("couponUsedSum", (Object)couponFindCouponCountResponseVO.getCouponUsedSum());
        jsonObject.put("couponRate", (Object)couponFindCouponCountResponseVO.getCouponRate());
        jsonObject.put("guestPrice", (Object)("\u00a5" + BaseData.guestPrice((String)jsonObject.getString("achievements"), (String)jsonObject.getString("penNumber")).toString()));
        jsonObject.put("jointRate", (Object)BaseData.growthNotTow((String)jsonObject.getString("pieceNumber"), (String)jsonObject.getString("penNumber")));
        jsonObject.put("roi", (Object)BaseData.growthNot((String)jsonObject.getString("achievements"), (String)jsonObject.getString("discount")));
        jsonObject.put("achievements", (Object)("\u00a5" + jsonObject.getString("achievements")));
        responseData.setData((Object)jsonObject);
        return responseData;
    }

    @ApiOperation(value="\u6838\u9500\u91cf", notes="\u6838\u9500\u91cf", tags={"\u6838\u9500\u91cf"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="batchNo", value="batchNo", required=true, dataType="batchNo")})
    @PostMapping(value={"vouSalesVolume"})
    public ResponseData<JSONArray> vouSalesVolume(BitDataVO sendVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        JSONArray jsonArray = new JSONArray();
        responseData = this.backJsonArray(JSONObject.parseObject((String)JSONObject.toJSONString((Object)sendVO)), jsonArray, this.baseUrl.getLoadUrl("vouSalesVolume"), request);
        responseData.setData((Object)jsonArray);
        return responseData;
    }

    @PostMapping(value={"salesNum"})
    public ResponseData<JSONObject> salesNum(SalesNumVO sendVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        JSONObject backJsonObject = new JSONObject();
        for (String key : "yesteryearData,lastData,currentData,useVouData,elseData".split(",")) {
            backJsonObject.put(key, (Object)"0");
        }
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        sendVO.setBrandId(sysAccountPo.getBrandId().toString());
        BaseData.salesNumVoDate((SalesNumVO)sendVO);
        responseData = this.backJsonObject(JSONObject.parseObject((String)JSONObject.toJSONString((Object)sendVO)), backJsonObject, this.baseUrl.getLoadUrl("salesNum"), request);
        JSONObject jsonObject = (JSONObject)responseData.getData();
        jsonObject.put("yesteryearDataGrowth", (Object)BaseData.growth((String)jsonObject.getString("currentData"), (String)jsonObject.getString("yesteryearData")));
        jsonObject.put("lastDataGrowth", (Object)BaseData.growth((String)jsonObject.getString("currentData"), (String)jsonObject.getString("lastData")));
        jsonObject.put("elseDataGrowth", (Object)BaseData.growthNot((String)jsonObject.getString("elseData"), (String)jsonObject.getString("currentData")));
        jsonObject.put("useVouDataGrowth", (Object)BaseData.growthNot((String)jsonObject.getString("useVouData"), (String)jsonObject.getString("currentData")));
        responseData.setData((Object)jsonObject);
        return responseData;
    }

    @PostMapping(value={"salesAchievements"})
    public ResponseData<JSONObject> salesAchievements(SalesNumVO sendVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        JSONObject backJsonObject = new JSONObject();
        for (String key : "yesteryearData,lastData,currentData,useVouData,elseData".split(",")) {
            backJsonObject.put(key, (Object)"0");
        }
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        sendVO.setBrandId(sysAccountPo.getBrandId().toString());
        BaseData.salesNumVoDate((SalesNumVO)sendVO);
        responseData = this.backJsonObject(JSONObject.parseObject((String)JSONObject.toJSONString((Object)sendVO)), backJsonObject, this.baseUrl.getLoadUrl("salesAchievements"), request);
        JSONObject jsonObject = (JSONObject)responseData.getData();
        jsonObject.put("yesteryearDataGrowth", (Object)BaseData.growth((String)jsonObject.getString("currentData"), (String)jsonObject.getString("yesteryearData")));
        jsonObject.put("lastDataGrowth", (Object)BaseData.growth((String)jsonObject.getString("currentData"), (String)jsonObject.getString("lastData")));
        jsonObject.put("elseDataGrowth", (Object)BaseData.growthNot((String)jsonObject.getString("elseData"), (String)jsonObject.getString("currentData")));
        jsonObject.put("useVouDataGrowth", (Object)BaseData.growthNot((String)jsonObject.getString("useVouData"), (String)jsonObject.getString("currentData")));
        responseData.setData((Object)jsonObject);
        return responseData;
    }

    @PostMapping(value={"storeTop"})
    public ResponseData<JSONObject> storeTop(BitDataVO sendVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        JSONObject backJsonObject = new JSONObject();
        responseData = this.backJsonObject(JSONObject.parseObject((String)JSONObject.toJSONString((Object)sendVO)), backJsonObject, this.baseUrl.getLoadUrl("storeTop"), request);
        return responseData;
    }

    @PostMapping(value={"areaTop"})
    public ResponseData<JSONObject> areaTop(BitDataVO sendVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        JSONObject backJsonObject = new JSONObject();
        responseData = this.backJsonObject(JSONObject.parseObject((String)JSONObject.toJSONString((Object)sendVO)), backJsonObject, this.baseUrl.getLoadUrl("areaTop"), request);
        return responseData;
    }

    @PostMapping(value={"storeVou"})
    public ResponseData<List<JSONObject>> storeVou(BitDataVO sendVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        ArrayList backJsonObject = new ArrayList();
        responseData = this.backJsonObjectHaveId(sendVO, backJsonObject, this.baseUrl.getLoadUrl("storeVou"), request);
        return responseData;
    }

    @PostMapping(value={"areaVou"})
    public ResponseData<List<JSONObject>> areaVou(BitDataVO sendVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        ArrayList backJsonObject = new ArrayList();
        HashMap map = new HashMap();
        JSONObject jsonObjectsendVo = JSONObject.parseObject((String)JSONObject.toJSONString((Object)sendVO));
        responseData = this.backJsonObjectHaveIdVou(jsonObjectsendVo, backJsonObject, this.baseUrl.getLoadUrl("storeVou"), request);
        return responseData;
    }

    public ResponseData<JSONArray> backJsonArray(JSONObject sendVO, JSONArray backJsonObject, String analysisUrl, HttpServletRequest request) {
        JSONObject jsonObject = this.getSendApiKeyJsonObject(sendVO, request);
        ResponseData ResponseData2 = new ResponseData();
        ResponseEntity response = null;
        try {
            logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + jsonObject.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)jsonObject, String.class, new Object[0]);
        }
        catch (Exception e) {
            ResponseData2.setCode(500);
            ResponseData2.setMessage("\u5927\u6570\u636e\u670d\u52a1\u5f02\u5e38" + e.getMessage());
            ResponseData2.setData((Object)backJsonObject);
            return ResponseData2;
        }
        JSONObject jobObject = JSONObject.parseObject((String)((String)response.getBody()));
        if ("1".equals(jobObject.get((Object)"successFlag"))) {
            JSONObject job = jobObject.getJSONObject("data");
            TreeMap<String, String> mapjsonObje = new TreeMap<String, String>();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (Object kk : job.keySet()) {
                try {
                    Date date = simpleDateFormat.parse(kk.toString());
                    long ts = date.getTime();
                    mapjsonObje.put(String.valueOf(ts), kk.toString());
                }
                catch (ParseException e) {
                    logger.error("\u5f02\u5e38", (Throwable)e);
                }
            }
            for (Object k : mapjsonObje.keySet()) {
                JSONObject backObject = new JSONObject();
                backObject.put("time", mapjsonObje.get(k));
                backObject.put("value", job.get(mapjsonObje.get(k)));
                backJsonObject.add((Object)backObject);
            }
        }
        ResponseData2.setCode(0);
        ResponseData2.setMessage(jobObject.toString() + "\u5927\u6570\u636e\u5165\u53c2\u8bf7\u6c42:" + analysisUrl + jsonObject.toString());
        ResponseData2.setData((Object)backJsonObject);
        return ResponseData2;
    }

    public ResponseData<JSONObject> backJsonObject(JSONObject sendVo, JSONObject backJsonObject, String analysisUrl, HttpServletRequest request) {
        JSONObject jsonObject = this.getSendApiKeyJsonObject(sendVo, request);
        ResponseData ResponseData2 = new ResponseData();
        ResponseEntity response = null;
        try {
            logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + jsonObject.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)jsonObject, String.class, new Object[0]);
        }
        catch (Exception e) {
            ResponseData2.setCode(500);
            ResponseData2.setMessage("\u5927\u6570\u636e\u670d\u52a1\u5f02\u5e38" + e.getMessage());
            ResponseData2.setData((Object)backJsonObject);
            return ResponseData2;
        }
        JSONObject jobObject = JSONObject.parseObject((String)((String)response.getBody()));
        if ("1".equals(jobObject.get((Object)"successFlag"))) {
            JSONObject job = jobObject.getJSONObject("data");
            for (Object kk : job.keySet()) {
                backJsonObject.put(kk.toString(), (Object)job.get(kk).toString());
            }
        }
        ResponseData2.setCode(0);
        ResponseData2.setMessage(jobObject.toString() + "\u5927\u6570\u636e\u5165\u53c2\u8bf7\u6c42:" + analysisUrl + jsonObject.toString());
        ResponseData2.setData((Object)backJsonObject);
        return ResponseData2;
    }

    public ResponseData<List<JSONObject>> backJsonObjectHaveId(BitDataVO sendVo, List<JSONObject> backJsonObject, String analysisUrl, HttpServletRequest request) {
        JSONObject jsonObject = this.getSendApiKeyJsonObject(JSONObject.parseObject((String)JSONObject.toJSONString((Object)sendVo)), request);
        ResponseData ResponseData2 = new ResponseData();
        ResponseEntity response = null;
        try {
            logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + jsonObject.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)jsonObject, String.class, new Object[0]);
        }
        catch (Exception e) {
            ResponseData2.setCode(500);
            ResponseData2.setMessage("\u5927\u6570\u636e\u670d\u52a1\u5f02\u5e38" + e.getMessage());
            ResponseData2.setData(backJsonObject);
            return ResponseData2;
        }
        JSONObject jobObject = JSONObject.parseObject((String)((String)response.getBody()));
        if ("1".equals(jobObject.get((Object)"successFlag"))) {
            JSONObject job = jobObject.getJSONObject("data");
            for (Object k : job.keySet()) {
                JSONObject json = JSONObject.parseObject((String)job.get(k).toString());
                json.put(k.toString(), (Object)"\u5e97\u94fa\u7fa4\u4e3bTODO");
                backJsonObject.add(json);
            }
        }
        ResponseData2.setCode(0);
        ResponseData2.setMessage(jobObject.toString() + "\u5927\u6570\u636e\u8bf7\u6c42:" + analysisUrl + jsonObject.toString());
        ResponseData2.setData(backJsonObject);
        return ResponseData2;
    }

    public ResponseData<List<JSONObject>> backJsonObjectHaveIdVou(JSONObject jsonObjectVou, List<JSONObject> backJsonObject, String analysisUrl, HttpServletRequest request) {
        JSONObject jsonObject = this.getSendApiKeyJsonObject(jsonObjectVou, request);
        ResponseData ResponseData2 = new ResponseData();
        ResponseEntity response = null;
        try {
            logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + jsonObject.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)jsonObject, String.class, new Object[0]);
        }
        catch (Exception e) {
            ResponseData2.setCode(500);
            ResponseData2.setMessage("\u5927\u6570\u636e\u670d\u52a1\u5f02\u5e38" + e.getMessage());
            ResponseData2.setData(backJsonObject);
            return ResponseData2;
        }
        JSONObject jobObject = JSONObject.parseObject((String)((String)response.getBody()));
        if ("1".equals(jobObject.get((Object)"successFlag"))) {
            JSONObject job = jobObject.getJSONObject("data");
            for (Object k : job.keySet()) {
                JSONObject json = JSONObject.parseObject((String)job.get(k).toString());
                json.put(k.toString(), (Object)"\u5e97\u94fa\u7fa4\u4e3bTODO");
                backJsonObject.add(json);
            }
        }
        ResponseData2.setCode(0);
        ResponseData2.setMessage(jobObject.toString() + "\u5927\u6570\u636e\u8bf7\u6c42:" + analysisUrl + jsonObject.toString());
        ResponseData2.setData(backJsonObject);
        return ResponseData2;
    }

    public JSONObject getSendApiKeyJsonObject(JSONObject jsonObject, HttpServletRequest request) {
        jsonObject.put("businessNum", (Object)this.baseUrl.getBusinessNum());
        jsonObject.put("apiKey", (Object)this.baseUrl.getApiKey());
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        ResponseData SysCompanyP = this.companyServiceRpc.getCompanyById(sysAccountPO.getSysCompanyId());
        jsonObject.put("corpId", (Object)((SysCompanyPo)SysCompanyP.getData()).getCompanyCode());
        SysBrandPo sysBrandPo = (SysBrandPo)this.brandServiceRpc.getBrandByID(sysAccountPO.getBrandId()).getData();
        jsonObject.put("brandId", (Object)sysBrandPo.getBrandCode());
        return jsonObject;
    }
}

