/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.common.utils;

import com.bizvane.centerstageservice.models.vo.TaskProgressVo;
import com.bizvane.centerstageservice.rpc.SysBatchTaskRpc;
import com.bizvane.couponservice.common.utils.TaskProcessHelper;
import com.bizvane.members.facade.models.bo.BatchTaskProcessBo;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskProcessScheduler {
    private static final Logger log = LoggerFactory.getLogger(TaskProcessScheduler.class);
    @Autowired
    private SysBatchTaskRpc sysBatchTaskRpc;
    private static ScheduledExecutorService es = Executors.newScheduledThreadPool(1);

    @PostConstruct
    public void init() {
        es.scheduleWithFixedDelay(() -> TaskProcessHelper.queryTaskMap().entrySet().forEach(entry -> {
            try {
                BatchTaskProcessBo batchTaskProcessBo = (BatchTaskProcessBo)entry.getValue();
                Integer progress = TaskProcessHelper.getExportPercentageProcess((String)((String)entry.getKey()));
                TaskProgressVo taskProgressVo = new TaskProgressVo();
                taskProgressVo.setSysCompanyId(batchTaskProcessBo.getSysCompanyId());
                taskProgressVo.setSysBrandId(batchTaskProcessBo.getSysBrandId());
                taskProgressVo.setBatchId(batchTaskProcessBo.getBatchId());
                if (batchTaskProcessBo.getOverFlag() != null && batchTaskProcessBo.getOverFlag().booleanValue()) {
                    taskProgressVo.setProgress(Integer.valueOf(100));
                    taskProgressVo.setFinishStatus(Integer.valueOf(1));
                    if (batchTaskProcessBo.getFailNum() == null || batchTaskProcessBo.getFailNum().intValue() == 0) {
                        taskProgressVo.setRetryStatus(Integer.valueOf(2));
                    } else {
                        taskProgressVo.setRetryStatus(Integer.valueOf(1));
                    }
                    taskProgressVo.setExportStatus(Integer.valueOf(1));
                    taskProgressVo.setExportUrl("");
                    TaskProcessHelper.queryTaskMap().remove(entry.getKey());
                } else {
                    taskProgressVo.setRetryStatus(Integer.valueOf(2));
                    taskProgressVo.setFinishStatus(Integer.valueOf(2));
                    taskProgressVo.setProgress(progress);
                }
                taskProgressVo.setSuccess(Long.valueOf(batchTaskProcessBo.getSuccessNum() == null ? 0L : batchTaskProcessBo.getSuccessNum().longValue()));
                taskProgressVo.setFail(Long.valueOf(batchTaskProcessBo.getFailNum() == null ? 0L : batchTaskProcessBo.getFailNum().longValue()));
                this.sysBatchTaskRpc.updateTaskProgress(taskProgressVo);
            }
            catch (Exception e) {
                log.error("TaskProcessScheduler", (Throwable)e);
            }
        }), 1L, 1L, TimeUnit.SECONDS);
    }
}

