/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.common.utils;

import com.bizvane.members.facade.models.bo.BatchTaskProcessBo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskProcessHelper {
    private static final Logger log = LoggerFactory.getLogger(TaskProcessHelper.class);
    private static Map<String, BatchTaskProcessBo> batchTaskProcessBoMap = new ConcurrentHashMap();

    public void init(String key, BatchTaskProcessBo batchTaskProcessBo) {
        batchTaskProcessBoMap.put(key, batchTaskProcessBo);
    }

    public synchronized Long stepSuccess(String key, Integer delta) {
        BatchTaskProcessBo batchTaskProcessBo = (BatchTaskProcessBo)batchTaskProcessBoMap.get(key);
        if (batchTaskProcessBo == null) {
            log.warn("\u4efb\u52a1\u5df2\u7ed3\u675f");
            return null;
        }
        AtomicLong atomicInteger = batchTaskProcessBo.getSuccessNum();
        AtomicLong handleNum = batchTaskProcessBo.getHandleNum();
        if (atomicInteger == null) {
            batchTaskProcessBo.setSuccessNum(new AtomicLong(0L));
        }
        if (handleNum == null) {
            batchTaskProcessBo.setHandleNum(new AtomicLong(0L));
        }
        batchTaskProcessBo.getHandleNum().addAndGet(delta.intValue());
        return batchTaskProcessBo.getSuccessNum().addAndGet(delta.intValue());
    }

    public synchronized Long stepFail(String key, Integer delta) {
        BatchTaskProcessBo batchTaskProcessBo = (BatchTaskProcessBo)batchTaskProcessBoMap.get(key);
        if (batchTaskProcessBo == null) {
            log.warn("\u4efb\u52a1\u5df2\u7ed3\u675f");
            return null;
        }
        AtomicLong atomicInteger = batchTaskProcessBo.getFailNum();
        AtomicLong handleNum = batchTaskProcessBo.getHandleNum();
        if (atomicInteger == null) {
            batchTaskProcessBo.setFailNum(new AtomicLong(0L));
        }
        if (handleNum == null) {
            batchTaskProcessBo.setHandleNum(new AtomicLong(0L));
        }
        batchTaskProcessBo.getHandleNum().addAndGet(delta.intValue());
        return batchTaskProcessBo.getFailNum().addAndGet(delta.intValue());
    }

    public synchronized void stepOver(String key) {
        BatchTaskProcessBo batchTaskProcessBo = (BatchTaskProcessBo)batchTaskProcessBoMap.get(key);
        if (batchTaskProcessBo == null) {
            log.warn("\u4efb\u52a1\u5df2\u7ed3\u675f");
            return;
        }
        batchTaskProcessBo.setOverFlag(Boolean.valueOf(true));
    }

    public static Map<String, BatchTaskProcessBo> queryTaskMap() {
        return batchTaskProcessBoMap;
    }

    public static Integer getExportPercentageProcess(String key) {
        BatchTaskProcessBo batchTaskProcessBo = (BatchTaskProcessBo)batchTaskProcessBoMap.get(key);
        if (batchTaskProcessBo == null) {
            return null;
        }
        Long totalNum = batchTaskProcessBo.getTotalNum();
        AtomicLong handle = batchTaskProcessBo.getHandleNum();
        if (totalNum == null || totalNum.equals(0L)) {
            return -1;
        }
        Long total = handle == null ? 0L : handle.longValue();
        Integer progress = new BigDecimal(total).divide(new BigDecimal(totalNum), 2, RoundingMode.DOWN).setScale(2, RoundingMode.DOWN).multiply(new BigDecimal(100)).intValue();
        return progress;
    }
}

