/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.common.utils;

import com.bizvane.couponservice.common.utils.SpringContextUtil;
import com.bizvane.couponservice.service.StreamingCallBack;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public class StreamingExportExcelPageInfoUtil<T> {
    private Log log = LogFactory.getLog(this.getClass());
    private Integer maxNumExcelSheetRow = 1000000;
    private Integer maxNumThreadPool = 1;
    private Integer perReadNum = 5000;
    private Long totalNumData = 0L;
    private Integer perSheetQuery = 0;
    private ExecutorService es = null;
    private SXSSFWorkbook wb = new SXSSFWorkbook(10);
    private Object obj = new Object();
    private static Map<Object, Long> totalMap = new ConcurrentHashMap();
    private static Map<Object, AtomicLong> progressMap = new ConcurrentHashMap();
    private Object exportProcessId;

    public StreamingExportExcelPageInfoUtil(Long totalNumData) {
        this.caculateMaxNumExcelSheetRow(this.maxNumExcelSheetRow, this.perReadNum);
        this.totalNumData = totalNumData;
        this.es = new ThreadPoolExecutor((int)this.maxNumThreadPool, (int)this.maxNumThreadPool, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public StreamingExportExcelPageInfoUtil(Integer perReadNum, Long totalNumData) {
        this.caculateMaxNumExcelSheetRow(this.maxNumExcelSheetRow, perReadNum);
        this.perReadNum = perReadNum;
        this.totalNumData = totalNumData;
        this.es = new ThreadPoolExecutor((int)this.maxNumThreadPool, (int)this.maxNumThreadPool, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public StreamingExportExcelPageInfoUtil(Integer maxNumExcelSheetRow, Integer perReadNum, Long totalNumData) {
        this.caculateMaxNumExcelSheetRow(maxNumExcelSheetRow, perReadNum);
        this.perReadNum = perReadNum;
        this.totalNumData = totalNumData;
        this.es = new ThreadPoolExecutor((int)this.maxNumThreadPool, (int)this.maxNumThreadPool, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public StreamingExportExcelPageInfoUtil(Integer maxNumThreadPool, Integer maxNumExcelSheetRow, Integer perReadNum, Long totalNumData) {
        this.caculateMaxNumExcelSheetRow(maxNumExcelSheetRow, perReadNum);
        this.maxNumThreadPool = maxNumThreadPool;
        this.perReadNum = perReadNum;
        this.totalNumData = totalNumData;
        this.es = new ThreadPoolExecutor((int)this.maxNumThreadPool, (int)this.maxNumThreadPool, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    protected void caculateMaxNumExcelSheetRow(Integer maxNumExcelSheetRow, Integer perReadNum) {
        int divide = maxNumExcelSheetRow / perReadNum;
        if (divide > 0) {
            int number = maxNumExcelSheetRow % perReadNum;
            if (number > 0) {
                if ((divide + 1) * perReadNum < 524288) {
                    this.maxNumExcelSheetRow = (divide + 1) * perReadNum;
                    this.perSheetQuery = divide + 1;
                } else {
                    this.perSheetQuery = this.maxNumExcelSheetRow / this.perReadNum;
                }
            } else if (divide * perReadNum < 524288) {
                this.maxNumExcelSheetRow = divide * perReadNum;
                this.perSheetQuery = divide;
            } else {
                this.perSheetQuery = this.maxNumExcelSheetRow / this.perReadNum;
            }
        }
    }

    protected void caculateMaxNumExcelSheetRow1(Integer maxNumExcelSheetRow, Integer perReadNum) {
        int divide = maxNumExcelSheetRow / perReadNum;
        if (divide > 0) {
            int number = maxNumExcelSheetRow % perReadNum;
            if (number > 0) {
                if ((divide + 1) * perReadNum < 524288) {
                    this.maxNumExcelSheetRow = (divide + 1) * perReadNum;
                    this.perSheetQuery = divide + 1;
                } else {
                    this.perSheetQuery = this.maxNumExcelSheetRow / this.perReadNum;
                }
            } else if (divide * perReadNum < 524288) {
                this.maxNumExcelSheetRow = divide * perReadNum;
                this.perSheetQuery = divide;
            } else {
                this.perSheetQuery = this.maxNumExcelSheetRow / this.perReadNum;
            }
        }
    }

    public void setExportProcessId(Object exportProcessId) {
        this.exportProcessId = exportProcessId;
        this.initProgress(exportProcessId);
    }

    protected void initProgress(Object exportProcessId) {
        totalMap.put(exportProcessId, this.totalNumData);
        progressMap.put(exportProcessId, new AtomicLong(0L));
    }

    public static AtomicLong getExportProcess(Object exportProcessId) {
        AtomicLong al = (AtomicLong)progressMap.get(exportProcessId);
        return al;
    }

    public static void removeExportProcess(Object exportProcessId) {
        progressMap.remove(exportProcessId);
    }

    public static BigDecimal getExportPercentageProcess(Object exportProcessId) {
        AtomicLong al = (AtomicLong)progressMap.get(exportProcessId);
        if (al != null) {
            long currentProcessRow = al.get();
            long total = (Long)totalMap.get(exportProcessId);
            if (total == 0L) {
                return new BigDecimal(-1);
            }
            return new BigDecimal(currentProcessRow).divide(new BigDecimal(total), 2, RoundingMode.DOWN).setScale(2, RoundingMode.DOWN);
        }
        return null;
    }

    public void read(String beanName, Method method, StreamingCallBack<T> callback, Sort sort, Object ... args) throws Exception {
        int i;
        Long startTimeMillis = System.currentTimeMillis();
        AtomicLong al = new AtomicLong(0L);
        if (this.exportProcessId != null) {
            progressMap.put(this.exportProcessId, al);
            totalMap.put(this.exportProcessId, this.totalNumData);
        }
        Integer sheetNum = (int)(this.totalNumData / (long)this.maxNumExcelSheetRow.intValue() + (long)(this.totalNumData % (long)this.maxNumExcelSheetRow.intValue() == 0L ? 0 : 1));
        CountDownLatch cd = new CountDownLatch(sheetNum);
        AtomicInteger ai = new AtomicInteger(0);
        Thread mainThread = Thread.currentThread();
        for (i = 0; i < sheetNum; ++i) {
            this.es.submit(() -> {
                try {
                    int pageSize;
                    int pageNum;
                    int sheetExecuteNum = ai.getAndIncrement();
                    Sheet sh = null;
                    Object object = this.obj;
                    synchronized (object) {
                        sh = this.wb.createSheet("sheet" + sheetExecuteNum);
                    }
                    Row row = sh.createRow(0);
                    callback.onCompletion(null, row);
                    int perQuery = 0;
                    while (perQuery * this.perReadNum < this.maxNumExcelSheetRow && ((long)((pageNum = sheetExecuteNum * this.perSheetQuery + perQuery + 1) * (pageSize = this.perReadNum.intValue())) <= this.totalNumData || (long)((pageNum - 1) * pageSize) < this.totalNumData)) {
                        PageRequest pageable = PageRequest.of((int)(pageNum - 1), (int)this.perReadNum, (Sort)sort);
                        Object bean = SpringContextUtil.getBean((String)beanName);
                        PageInfo page = null;
                        if (args != null && args.length > 0) {
                            int length = args.length;
                            Object[] realArgs = Arrays.copyOf(args, length + 1, Object[].class);
                            realArgs[length] = pageable;
                            page = (PageInfo)ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])realArgs);
                        } else {
                            page = (PageInfo)ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{pageable});
                        }
                        List datalist = page.getList();
                        for (int column = 0; column < datalist.size(); ++column) {
                            if (this.exportProcessId != null) {
                                al.incrementAndGet();
                            }
                            Object t = datalist.get(column);
                            Row row2 = sh.createRow(column + perQuery * this.perReadNum + 1);
                            callback.onCompletion(t, row2);
                        }
                        ++perQuery;
                    }
                    this.log.info((Object)("countDown:" + sheetExecuteNum));
                }
                catch (Exception e) {
                    this.log.error((Object)"\u5f02\u5e38\uff1a", (Throwable)e);
                    progressMap.put(this.exportProcessId, new AtomicLong(-1L));
                    this.es.shutdownNow();
                    this.log.error((Object)"\u5bfc\u51fa\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                    mainThread.interrupt();
                }
                finally {
                    cd.countDown();
                }
            });
        }
        cd.await();
        if (!this.es.isShutdown()) {
            this.es.shutdown();
        }
        for (i = 0; i < sheetNum; ++i) {
            this.wb.setSheetOrder("sheet" + i, i);
        }
        if (this.exportProcessId != null) {
            progressMap.put(this.exportProcessId, new AtomicLong(this.totalNumData));
            totalMap.put(this.exportProcessId, this.totalNumData);
        }
        Long endTimeMillis = System.currentTimeMillis();
        long internal = endTimeMillis - startTimeMillis;
        System.out.println("\u6267\u884c\u65f6\u95f4\uff1a" + internal);
    }

    public void exportToOutputStream(OutputStream os) throws IOException {
        this.wb.write(os);
        this.wb.dispose();
    }

    public static void main(String[] args) {
        BigDecimal bd = new BigDecimal("0.096");
        System.out.println(bd.setScale(2, RoundingMode.DOWN).multiply(new BigDecimal(100)).intValue());
    }

    public void exprotToZipOutputStream(OutputStream os, @NonNull String zipEntryName, @Nullable String comment) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(os);
        zipOut.putNextEntry(new ZipEntry(zipEntryName));
        zipOut.setComment(comment);
        this.wb.write((OutputStream)zipOut);
        this.wb.dispose();
    }
}

