/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponservice.common.utils.DateUtil;
import com.bizvane.couponservice.common.utils.HandleTemplateUtil;
import com.bizvane.couponservice.common.utils.JacksonUtil;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.messagebase.model.vo.StandardMessageVo;
import com.bizvane.messagebase.model.vo.StandardTemplateResponseVO;
import com.bizvane.messagebase.model.vo.StandardTemplateVo;
import com.bizvane.messagefacade.interfaces.StandardMessageSmsFeign;
import com.bizvane.messagefacade.models.vo.CouponMessageVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class StandardMessageUtil {
    private static final Logger log = LoggerFactory.getLogger(StandardMessageUtil.class);
    @Autowired
    private StandardMessageSmsFeign standardMessageSmsFeign;

    public ResponseData<String> useCouponMessage(CouponEntityPO couponEntityPo, WxChannelInfoVo channelInfoVo, CouponMessageVO messageVo) {
        ResponseData sendResponseData = new ResponseData();
        StandardTemplateVo standardTemplateVo = new StandardTemplateVo();
        standardTemplateVo.setSysCompanyId(couponEntityPo.getSysCompanyId());
        standardTemplateVo.setSysBrandId(couponEntityPo.getSysBrandId());
        standardTemplateVo.setTemplateType("COUPON_USE");
        ResponseData standardTemplateResponseVOResponseData = this.standardMessageSmsFeign.getTemplateInfoByTempType(standardTemplateVo);
        if (standardTemplateResponseVOResponseData == null || SysResponseEnum.FAILED.getCode() == standardTemplateResponseVOResponseData.getCode()) {
            log.error("\u67e5\u8be2\u77ed\u4fe1\u6a21\u677f\u5931\u8d25 param:{}", (Object)JacksonUtil.bean2Json((Object)standardTemplateVo));
            sendResponseData.setCode(SysResponseEnum.FAILED.getCode());
            sendResponseData.setMessage("\u67e5\u8be2\u6a21\u677f\u6d88\u606f\u5931\u8d25");
            return sendResponseData;
        }
        StandardTemplateResponseVO standardTemplateResponseVO = (StandardTemplateResponseVO)standardTemplateResponseVOResponseData.getData();
        if (standardTemplateResponseVO == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)standardTemplateResponseVO.getTemplateCodeCn()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)standardTemplateResponseVO.getTemplateCodeIntl()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)standardTemplateResponseVO.getContent())) {
            log.info("\u6a21\u677f\u672a\u914d\u7f6e param:{}", (Object)JacksonUtil.bean2Json((Object)standardTemplateVo));
            sendResponseData.setCode(SysResponseEnum.FAILED.getCode());
            sendResponseData.setMessage("\u6a21\u677f\u6d88\u606f\u4e3a\u7a7a");
            return sendResponseData;
        }
        String content = standardTemplateResponseVO.getContent();
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)messageVo);
        content = HandleTemplateUtil.handleUseCouponTemplate((String)content, (JSONObject)jsonObject);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("memberName", messageVo.getMemberName());
        paramMap.put("couponName", messageVo.getCouponName());
        paramMap.put("couponInfo", messageVo.getDenomination());
        paramMap.put("couponNo", messageVo.getCouponCode());
        paramMap.put("pub", messageVo.getNickName());
        paramMap.put("couponConsumeTime", DateUtil.format((Date)messageVo.getUseTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        StandardMessageVo standardMessageVo = new StandardMessageVo();
        standardMessageVo.setSysCompanyId(channelInfoVo.getSysCompanyId());
        standardMessageVo.setSysBrandId(couponEntityPo.getSysBrandId());
        standardMessageVo.setMemberName(channelInfoVo.getName());
        standardMessageVo.setPhone(channelInfoVo.getPhone());
        standardMessageVo.setMsgContent(content);
        standardMessageVo.setScene("COUPON_USE");
        String serviceStoreCode = !StringUtils.isEmpty((Object)messageVo.getServiceStoreCode()) ? messageVo.getServiceStoreCode() : "default";
        standardMessageVo.setMemberOnlineServiceStoreCode(serviceStoreCode);
        standardMessageVo.setTemplateCodeCn(standardTemplateResponseVO.getTemplateCodeCn());
        standardMessageVo.setTemplateCodeIntl(standardTemplateResponseVO.getTemplateCodeIntl());
        standardMessageVo.setParamMap(paramMap);
        standardMessageVo.setMsgSysStoreId(messageVo.getServiceStoreId());
        standardMessageVo.setMsgTaskType(Integer.valueOf(5));
        standardMessageVo.setAreaCode(messageVo.getAreaCode());
        sendResponseData = this.standardMessageSmsFeign.sendSingleMessage(standardMessageVo);
        log.info("\u8c03\u7528standardMessageSmsFeign,\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)standardMessageVo));
        int code = sendResponseData.getCode();
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == code) {
            log.info("\u8c03\u7528sms sendSingleMessage\u6210\u529f,\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)standardMessageVo));
        }
        return sendResponseData;
    }

    public ResponseData<String> receiveCouponMessage(CouponMessageVO messageVO) {
        ResponseData sendResponseData = new ResponseData();
        StandardTemplateVo standardTemplateVo = new StandardTemplateVo();
        standardTemplateVo.setSysCompanyId(messageVO.getSysCompanyId());
        standardTemplateVo.setSysBrandId(messageVO.getSysBrandId());
        standardTemplateVo.setTemplateType("COUPON_RECEIVE");
        ResponseData standardTemplateResponseVOResponseData = this.standardMessageSmsFeign.getTemplateInfoByTempType(standardTemplateVo);
        if (standardTemplateResponseVOResponseData == null || SysResponseEnum.FAILED.getCode() == standardTemplateResponseVOResponseData.getCode()) {
            log.error("\u67e5\u8be2\u77ed\u4fe1\u6a21\u677f\u5931\u8d25 param:{}", (Object)JacksonUtil.bean2Json((Object)standardTemplateVo));
            sendResponseData.setCode(SysResponseEnum.FAILED.getCode());
            sendResponseData.setMessage("\u67e5\u8be2\u6a21\u677f\u6d88\u606f\u5931\u8d25");
            return sendResponseData;
        }
        StandardTemplateResponseVO standardTemplateResponseVO = (StandardTemplateResponseVO)standardTemplateResponseVOResponseData.getData();
        if (standardTemplateResponseVO == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)standardTemplateResponseVO.getTemplateCodeCn()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)standardTemplateResponseVO.getTemplateCodeIntl()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)standardTemplateResponseVO.getContent())) {
            log.info("\u6a21\u677f\u672a\u914d\u7f6e param:{}", (Object)JacksonUtil.bean2Json((Object)standardTemplateVo));
            sendResponseData.setCode(SysResponseEnum.FAILED.getCode());
            sendResponseData.setMessage("\u6a21\u677f\u6d88\u606f\u4e3a\u7a7a");
            return sendResponseData;
        }
        String content = standardTemplateResponseVO.getContent();
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)messageVO);
        content = HandleTemplateUtil.handleReceiveCouponTemplate((String)content, (JSONObject)jsonObject);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("memberName", messageVO.getMemberName());
        paramMap.put("couponName", messageVO.getCouponName());
        paramMap.put("couponInfo", messageVO.getDenomination());
        paramMap.put("couponNo", messageVO.getCouponCode());
        paramMap.put("pub", messageVO.getNickName());
        paramMap.put("couponComeTime", DateUtil.format((Date)messageVO.getUseTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        StandardMessageVo standardMessageVo = new StandardMessageVo();
        standardMessageVo.setSysCompanyId(messageVO.getSysCompanyId());
        standardMessageVo.setSysBrandId(messageVO.getSysBrandId());
        standardMessageVo.setMemberName(messageVO.getMemberName());
        standardMessageVo.setPhone(messageVO.getMemberPhone());
        standardMessageVo.setMsgContent(content);
        standardMessageVo.setScene("COUPON_RECEIVE");
        String serviceStoreCode = !StringUtils.isEmpty((Object)messageVO.getServiceStoreCode()) ? messageVO.getServiceStoreCode() : "default";
        standardMessageVo.setMemberOnlineServiceStoreCode(serviceStoreCode);
        standardMessageVo.setTemplateCodeCn(standardTemplateResponseVO.getTemplateCodeCn());
        standardMessageVo.setTemplateCodeIntl(standardTemplateResponseVO.getTemplateCodeIntl());
        standardMessageVo.setParamMap(paramMap);
        standardMessageVo.setMsgSysStoreId(messageVO.getServiceStoreId());
        standardMessageVo.setMsgTaskType(Integer.valueOf(5));
        standardMessageVo.setAreaCode(messageVO.getAreaCode());
        sendResponseData = this.standardMessageSmsFeign.sendSingleMessage(standardMessageVo);
        log.info("\u8c03\u7528standardMessageSmsFeign,\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)standardMessageVo));
        int code = sendResponseData.getCode();
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == code) {
            log.info("\u8c03\u7528sms sendSingleMessage\u6210\u529f,\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)standardMessageVo));
        }
        return sendResponseData;
    }

    public ResponseData<String> expireCouponMessage(CouponMessageVO messageVO) {
        ResponseData sendResponseData = new ResponseData();
        StandardTemplateVo standardTemplateVo = new StandardTemplateVo();
        standardTemplateVo.setSysCompanyId(messageVO.getSysCompanyId());
        standardTemplateVo.setSysBrandId(messageVO.getSysBrandId());
        standardTemplateVo.setTemplateType("COUPON_EXPIRE");
        ResponseData standardTemplateResponseVOResponseData = this.standardMessageSmsFeign.getTemplateInfoByTempType(standardTemplateVo);
        if (standardTemplateResponseVOResponseData == null || SysResponseEnum.FAILED.getCode() == standardTemplateResponseVOResponseData.getCode()) {
            log.error("\u67e5\u8be2\u77ed\u4fe1\u6a21\u677f\u5931\u8d25 param:{}", (Object)JacksonUtil.bean2Json((Object)standardTemplateVo));
            sendResponseData.setCode(SysResponseEnum.FAILED.getCode());
            sendResponseData.setMessage("\u67e5\u8be2\u6a21\u677f\u6d88\u606f\u5931\u8d25");
            return sendResponseData;
        }
        StandardTemplateResponseVO standardTemplateResponseVO = (StandardTemplateResponseVO)standardTemplateResponseVOResponseData.getData();
        if (standardTemplateResponseVO == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)standardTemplateResponseVO.getTemplateCodeCn()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)standardTemplateResponseVO.getTemplateCodeIntl()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)standardTemplateResponseVO.getContent())) {
            log.info("\u6a21\u677f\u672a\u914d\u7f6e param:{}", (Object)JacksonUtil.bean2Json((Object)standardTemplateVo));
            sendResponseData.setCode(SysResponseEnum.FAILED.getCode());
            sendResponseData.setMessage("\u6a21\u677f\u6d88\u606f\u4e3a\u7a7a");
            return sendResponseData;
        }
        String content = standardTemplateResponseVO.getContent();
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)messageVO);
        content = HandleTemplateUtil.handleExpireCouponTemplate((String)content, (JSONObject)jsonObject);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("memberName", messageVO.getMemberName());
        paramMap.put("couponName", messageVO.getCouponName());
        paramMap.put("couponInfo", messageVO.getDenomination());
        paramMap.put("couponNo", messageVO.getCouponCode());
        paramMap.put("pub", messageVO.getNickName());
        paramMap.put("couponExpireTime", DateUtil.format((Date)messageVO.getValidDateEnd(), (String)"yyyy-MM-dd HH:mm:ss"));
        StandardMessageVo standardMessageVo = new StandardMessageVo();
        standardMessageVo.setSysCompanyId(messageVO.getSysCompanyId());
        standardMessageVo.setSysBrandId(messageVO.getSysBrandId());
        standardMessageVo.setMemberName(messageVO.getMemberName());
        standardMessageVo.setPhone(messageVO.getMemberPhone());
        standardMessageVo.setMsgContent(content);
        standardMessageVo.setScene("COUPON_EXPIRE");
        String serviceStoreCode = !StringUtils.isEmpty((Object)messageVO.getServiceStoreCode()) ? messageVO.getServiceStoreCode() : "default";
        standardMessageVo.setMemberOnlineServiceStoreCode(serviceStoreCode);
        standardMessageVo.setTemplateCodeCn(standardTemplateResponseVO.getTemplateCodeCn());
        standardMessageVo.setTemplateCodeIntl(standardTemplateResponseVO.getTemplateCodeIntl());
        standardMessageVo.setParamMap(paramMap);
        standardMessageVo.setMsgSysStoreId(messageVO.getServiceStoreId());
        standardMessageVo.setMsgTaskType(Integer.valueOf(5));
        standardMessageVo.setAreaCode(messageVO.getAreaCode());
        sendResponseData = this.standardMessageSmsFeign.sendSingleMessage(standardMessageVo);
        log.info("\u8c03\u7528standardMessageSmsFeign,\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)standardMessageVo));
        int code = sendResponseData.getCode();
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == code) {
            log.info("\u8c03\u7528sms sendSingleMessage\u6210\u529f,\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)standardMessageVo));
        }
        return sendResponseData;
    }
}

