/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.common.utils;

import com.bizvane.centerstageservice.models.vo.QiNiuVo;
import com.bizvane.couponservice.common.utils.QiNiuConfig;
import com.bizvane.couponservice.common.utils.SpringContextHolder;
import com.bizvane.couponservice.common.utils.SpringContextUtil;
import com.google.gson.Gson;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.util.Auth;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class QiNiuUtil {
    private static final Logger log = LoggerFactory.getLogger(QiNiuUtil.class);
    private static Configuration cfg = new Configuration(Zone.zone0());
    private static UploadManager uploadManager = new UploadManager(cfg);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadUrl(String url, String key) {
        InputStream in = null;
        try {
            in = new URL(url).openStream();
        }
        catch (MalformedURLException e1) {
            log.error("\u5f02\u5e38\uff1a", (Object)ExceptionUtils.getStackTrace((Throwable)e1));
        }
        catch (IOException e1) {
            log.error("\u5f02\u5e38\uff1a", (Object)ExceptionUtils.getStackTrace((Throwable)e1));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error("\u5f02\u5e38\uff1a", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        try {
            UploadManager uploadManager = QiNiuUtil.getUploadManager();
            String token = QiNiuUtil.getToken();
            Response response = uploadManager.put(in, key, token, null, null);
            DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            String domain = ((QiNiuConfig)SpringContextUtil.getBean(QiNiuConfig.class)).getDomain();
            String qiniuUrl = domain + "/" + putRet.key;
            return qiniuUrl;
        }
        catch (Exception e) {
            log.error("e:", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static String upload(InputStream in, String key) {
        try {
            UploadManager uploadManager = QiNiuUtil.getUploadManager();
            String token = QiNiuUtil.getToken();
            Response response = uploadManager.put(in, key, token, null, null);
            DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            String domain = ((QiNiuConfig)SpringContextUtil.getBean(QiNiuConfig.class)).getDomain();
            String url = domain + "/" + putRet.key;
            return url;
        }
        catch (Exception e) {
            log.error("e:", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static String upload(String bucketNm, File file) {
        try {
            UploadManager uploadManager = QiNiuUtil.getUploadManager();
            String token = QiNiuUtil.getToken();
            Response response = uploadManager.put(file.getAbsolutePath(), QiNiuUtil.newName((String)file.getName()), token);
            DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            String domain = ((QiNiuConfig)SpringContextUtil.getBean(QiNiuConfig.class)).getDomain();
            String url = domain + "/" + putRet.key;
            return url;
        }
        catch (QiniuException e) {
            log.error("\u5f02\u5e38\uff1a", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public QiNiuVo upload(String bucketNm, InputStream in, String key) {
        QiNiuVo result = null;
        try {
            UploadManager uploadManager = this.getUploadManager(bucketNm);
            String token = this.getToken(bucketNm);
            Response response = uploadManager.put(in, key, token, null, null);
            DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            log.info("putRet.key:{},putRet.hash:{}", (Object)putRet.key, (Object)putRet.hash);
            result = new QiNiuVo(true, putRet.key);
        }
        catch (Exception e) {
            result = new QiNiuVo(false);
            log.info("QiNiuUtil upload\u5f02\u5e38:{},\u5f02\u5e38\u5806\u6808:{}", (Object)e.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        return result;
    }

    public UploadManager getUploadManager(String bucketNm) {
        Configuration cfg = new Configuration(Zone.zone0());
        UploadManager uploadManager = new UploadManager(cfg);
        return uploadManager;
    }

    public String getToken(String bucketNm) {
        QiNiuConfig qiNiuConfig = (QiNiuConfig)SpringContextHolder.getApplicationContext().getBean(QiNiuConfig.class);
        Auth auth = Auth.create((String)qiNiuConfig.getAccessKey(), (String)qiNiuConfig.getSecretKey());
        String upToken = auth.uploadToken(bucketNm);
        return upToken;
    }

    public static String newName(String oldName) {
        String[] datas = oldName.split("\\.");
        String type = datas[datas.length - 1];
        String newName = UUID.randomUUID().toString() + "." + type;
        return newName;
    }

    public static UploadManager getUploadManager() {
        return uploadManager;
    }

    private static String getToken() {
        QiNiuConfig qiNiuConfig = (QiNiuConfig)SpringContextUtil.getBean(QiNiuConfig.class);
        Auth auth = Auth.create((String)qiNiuConfig.getAccessKey(), (String)qiNiuConfig.getSecretKey());
        String upToken = auth.uploadToken(qiNiuConfig.getBucketNm());
        return upToken;
    }
}

