/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponservice.common.utils.DateUtil;
import com.bizvane.couponservice.common.utils.XxlJobConfig;
import com.bizvane.utils.enumutils.JobEnum;
import com.bizvane.utils.jobutils.JobBusinessTypeEnum;
import com.bizvane.utils.jobutils.JobClient;
import com.bizvane.utils.jobutils.XxlJobInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class JobUtil {
    @Autowired
    private XxlJobConfig xxlJobConfig;
    @Autowired
    private JobClient jobClient;
    public static final String DEFAULT_STR = "\u65e0";

    public ResponseData<Integer> sendCouponExpireJob() {
        ResponseData responseData = new ResponseData();
        String jobHandler = "couponExpireJobHandler";
        String taskName = "\u5238\u5230\u671f\u63d0\u9192";
        String execuRule = "0 0 12 * * ?";
        ResponseEntity responseEntity = this.addRuleJob(execuRule, taskName, null, null, jobHandler, null, null);
        JSONObject jsonObject = JSON.parseObject((String)((String)responseEntity.getBody()));
        Integer code = jsonObject.getInteger("code");
        String msg = jsonObject.getString("msg");
        responseData.setCode(code.intValue());
        responseData.setMessage(msg);
        return responseData;
    }

    public ResponseData<Integer> addSendCouponBatchJob(SendCouponBatchRequestVO param) {
        ResponseData responseData = new ResponseData();
        String jobHandler = "sendBatchJobHandler";
        String businessType = SendTypeEnum.SEND_COUPON_BATCH.getCode();
        String businessCode = param.getBusinessId() + "";
        String jsonStr = JSONObject.toJSONString((Object)param);
        ResponseEntity responseEntity = this.addDateJob(param.getSendTime(), param.getBusinessName(), jsonStr, param.getCreateUserName(), jobHandler, businessType, businessCode);
        JSONObject jsonObject = JSON.parseObject((String)((String)responseEntity.getBody()));
        Integer code = jsonObject.getInteger("code");
        String msg = jsonObject.getString("msg");
        responseData.setCode(code.intValue());
        responseData.setMessage(msg);
        return responseData;
    }

    public ResponseEntity<String> addDateJob(Date execuDate, String desc, String param, String author, String jobHandler, String businessType, String bizCode) {
        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setAppName(this.xxlJobConfig.getAppName());
        xxlJobInfo.setExecutorRouteStrategy(JobEnum.EXECUTOR_ROUTE_STRATEGY_FIRST.getValue());
        xxlJobInfo.setJobCron(DateUtil.getCronExpression((Date)execuDate));
        xxlJobInfo.setGlueType(JobEnum.GLUE_TYPE_BEAN.getValue());
        xxlJobInfo.setExecutorHandler(jobHandler);
        if (StringUtils.isBlank((CharSequence)desc)) {
            desc = DEFAULT_STR;
        }
        xxlJobInfo.setJobDesc(desc);
        xxlJobInfo.setExecutorParam(param);
        xxlJobInfo.setExecutorBlockStrategy(JobEnum.EXECUTOR_BLOCK_SERIAL_EXECUTION.getValue());
        xxlJobInfo.setExecutorFailStrategy(JobEnum.EXECUTOR_FAIL_STRATEGY_NULL.getValue());
        if (StringUtils.isBlank((CharSequence)author)) {
            author = DEFAULT_STR;
        }
        xxlJobInfo.setAuthor(author);
        xxlJobInfo.setBizType(Integer.valueOf(JobBusinessTypeEnum.ACTIVITY_TYPE_COUPON.getCode()));
        xxlJobInfo.setBizCode(JobBusinessTypeEnum.ACTIVITY_TYPE_COUPON.getCode() + "");
        ResponseEntity responseEntity = this.jobClient.addJob(xxlJobInfo);
        return responseEntity;
    }

    public ResponseEntity<String> addRuleJob(String execuRule, String desc, String param, String author, String jobHandler, String businessType, String bizCode) {
        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setAppName(this.xxlJobConfig.getAppName());
        xxlJobInfo.setExecutorRouteStrategy(JobEnum.EXECUTOR_ROUTE_STRATEGY_FIRST.getValue());
        xxlJobInfo.setJobCron(execuRule);
        xxlJobInfo.setGlueType(JobEnum.GLUE_TYPE_BEAN.getValue());
        xxlJobInfo.setExecutorHandler(jobHandler);
        if (StringUtils.isBlank((CharSequence)desc)) {
            desc = DEFAULT_STR;
        }
        xxlJobInfo.setJobDesc(desc);
        xxlJobInfo.setExecutorParam(param);
        xxlJobInfo.setExecutorBlockStrategy(JobEnum.EXECUTOR_BLOCK_SERIAL_EXECUTION.getValue());
        xxlJobInfo.setExecutorFailStrategy(JobEnum.EXECUTOR_FAIL_STRATEGY_NULL.getValue());
        if (StringUtils.isBlank((CharSequence)author)) {
            author = DEFAULT_STR;
        }
        xxlJobInfo.setAuthor(author);
        xxlJobInfo.setBizType(Integer.valueOf(JobBusinessTypeEnum.ACTIVITY_TYPE_COUPON.getCode()));
        xxlJobInfo.setBizCode(JobBusinessTypeEnum.ACTIVITY_TYPE_COUPON.getCode() + "");
        ResponseEntity responseEntity = this.jobClient.addJob(xxlJobInfo);
        return responseEntity;
    }
}

