/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.common.utils;

import com.alibaba.fastjson.JSON;
import com.bizvane.centerstageservice.models.po.SysAccountPo;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static boolean editCookie(Cookie[] cookies, HttpServletResponse response, String name, String value) {
        if (cookies == null || cookies.length == 0) {
            return false;
        }
        for (Cookie item : cookies) {
            if (!item.getName().equals(name)) continue;
            Cookie cookie = new Cookie(name, value);
            cookie.setComment(item.getComment());
            String domain = item.getDomain();
            if (StringUtils.isNotBlank((CharSequence)domain)) {
                cookie.setDomain(domain);
            }
            cookie.setMaxAge(item.getMaxAge());
            cookie.setPath("/");
            cookie.setSecure(item.getSecure());
            cookie.setVersion(item.getVersion());
            response.addCookie(cookie);
            return true;
        }
        return false;
    }

    public static SysAccountPo getLoginUser(HttpServletRequest request) {
        String json = "";
        try {
            json = URLDecoder.decode(request.getHeader("sysAccountPo"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u5f02\u5e38\uff1a", (Throwable)e);
        }
        SysAccountPo sysAccountPo = (SysAccountPo)JSON.parseObject((String)json, SysAccountPo.class);
        return sysAccountPo;
    }
}

