/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleTemplateUtil {
    private static final Logger log = LoggerFactory.getLogger(HandleTemplateUtil.class);

    private HandleTemplateUtil() {
    }

    public static String handleUseCouponTemplate(String template, JSONObject jsonObject) {
        String couponName;
        Date taskTime;
        SimpleDateFormat formatterA = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtils.isBlank((CharSequence)template)) {
            return null;
        }
        String memberName = jsonObject.getString("memberName");
        if (StringUtils.isNotEmpty((CharSequence)memberName)) {
            template = template.replace("@[\u4f1a\u5458\u59d3\u540d]", memberName);
        }
        if ((taskTime = jsonObject.getDate("useTime")) != null) {
            template = template.replace("@[\u4f18\u60e0\u5238\u6838\u9500\u65f6\u95f4]", formatterA.format(taskTime));
        }
        if (StringUtils.isNotEmpty((CharSequence)(couponName = jsonObject.getString("couponName")))) {
            template = template.replace("@[\u4f18\u60e0\u5238\u540d\u79f0]", couponName);
        }
        String denomination = jsonObject.getString("denomination");
        if (StringUtils.isNotEmpty((CharSequence)couponName)) {
            template = template.replace("@[\u4f18\u60e0\u5238\u540d\u79f0]", denomination);
        }
        String couponCode = jsonObject.getString("couponCode");
        if (StringUtils.isNotEmpty((CharSequence)couponName)) {
            template = template.replace("@[\u5238\u53f7]", couponCode);
        }
        String nickName = jsonObject.getString("nickName");
        if (StringUtils.isNotEmpty((CharSequence)couponName)) {
            template = template.replace("@[\u516c\u4f17\u53f7]", nickName);
        }
        return template + ",\u9000\u8ba2\u56de\u590dTD";
    }

    public static String handleReceiveCouponTemplate(String template, JSONObject jsonObject) {
        Date taskTime = jsonObject.getDate("useTime");
        if (StringUtils.isBlank((CharSequence)template)) {
            return null;
        }
        String msgContent = template.replace("@[\u4f1a\u5458\u59d3\u540d]", StringUtils.defaultString((String)jsonObject.getString("memberName"))).replace("@[\u4f18\u60e0\u5238\u540d\u79f0]", StringUtils.defaultString((String)jsonObject.getString("couponName"))).replace("@[\u5238\u53f7]", StringUtils.defaultString((String)jsonObject.getString("couponCode"))).replace("@[\u516c\u4f17\u53f7]", StringUtils.defaultString((String)jsonObject.getString("nickName")));
        msgContent = msgContent.replace("@[\u4f18\u60e0\u5238\u6298\u6263/\u91d1\u989d]", "");
        SimpleDateFormat formatterA = new SimpleDateFormat("yyyy-MM-dd");
        msgContent = msgContent.replace("@[\u4f18\u60e0\u5238\u5165\u8d26\u65f6\u95f4]", formatterA.format(taskTime));
        return msgContent + ",\u9000\u8ba2\u56de\u590dTD";
    }

    public static String handleExpireCouponTemplate(String template, JSONObject jsonObject) {
        if (StringUtils.isBlank((CharSequence)template)) {
            return null;
        }
        String validDateEnd = StringUtils.defaultString((String)jsonObject.getString("validDateEnd"));
        String memberName = jsonObject.getString("memberName");
        template = template.replace("@[\u4f18\u60e0\u5238\u5230\u671f\u65f6\u95f4]", validDateEnd).replace("@[\u4f18\u60e0\u5238\u540d\u79f0]", StringUtils.defaultString((String)jsonObject.getString("couponName"))).replace("@[\u4f18\u60e0\u5238\u6298\u6263/\u91d1\u989d]", StringUtils.defaultString((String)jsonObject.getString("denomination"))).replace("@[\u5238\u53f7]", StringUtils.defaultString((String)jsonObject.getString("couponCode"))).replace("@[\u516c\u4f17\u53f7]", StringUtils.defaultString((String)jsonObject.getString("nickName")));
        return template + ",\u9000\u8ba2\u56de\u590dTD";
    }
}

