/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.models.vo.QiNiuVo;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.couponservice.common.utils.FileNameUtil;
import com.bizvane.couponservice.common.utils.QiNiuConfig;
import com.bizvane.couponservice.common.utils.QiNiuUtil;
import com.bizvane.couponservice.common.utils.SpringContextHolder;
import com.bizvane.couponservice.common.utils.StreamingExportExcelUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ExportExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExportExcelUtil.class);
    @Autowired
    private QiNiuConfig qiNiuConfig;
    private String sheetName;
    private String[] rowName;
    private List<JSONArray> dataList = new ArrayList();
    HttpServletResponse response;
    Date date = new Date();
    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");

    public ExportExcelUtil(String sheetName, String[] rowName, List<JSONArray> dataList, HttpServletResponse response) {
        this.dataList = dataList;
        this.rowName = rowName;
        this.sheetName = sheetName;
        this.response = response;
    }

    public void export() throws Exception {
        try {
            SXSSFWorkbook workbook = new SXSSFWorkbook();
            Sheet sheet = workbook.createSheet(this.sheetName);
            CellStyle columnTopStyle = this.getColumnTopStyle((Workbook)workbook);
            CellStyle style = this.getStyle((Workbook)workbook);
            int columnNum = this.rowName.length;
            Row rowRowName = sheet.createRow(0);
            for (int n = 0; n < columnNum; ++n) {
                Cell cellRowName = rowRowName.createCell(n);
                cellRowName.setCellType(1);
                HSSFRichTextString text = new HSSFRichTextString(this.rowName[n]);
                cellRowName.setCellValue((RichTextString)text);
                cellRowName.setCellStyle(columnTopStyle);
            }
            for (int i = 0; i < this.dataList.size(); ++i) {
                JSONArray arrayData = (JSONArray)this.dataList.get(i);
                Row row = sheet.createRow(i + 1);
                for (int j = 0; j < arrayData.size(); ++j) {
                    Cell cell = null;
                    String data = arrayData.getString(j);
                    cell = row.createCell(j, 1);
                    if (!"".equals(data) && data != null) {
                        cell.setCellValue(data);
                    } else {
                        cell.setCellValue("");
                    }
                    cell.setCellStyle(style);
                }
            }
            for (int colNum = 0; colNum < columnNum; ++colNum) {
                int columnWidth = sheet.getColumnWidth(colNum) / 256;
                if (colNum == 0) {
                    sheet.setColumnWidth(colNum, (columnWidth - 2) * 256);
                    continue;
                }
                int width = (columnWidth + 4) * 256;
                if (width > 10000) {
                    width = 10000;
                }
                sheet.setColumnWidth(colNum, width);
            }
            if (workbook != null) {
                try {
                    String fileNames = this.sheetName + ".xlsx";
                    String fileName = new String(fileNames.getBytes("GBK"), "iso8859-1");
                    String headStr = "attachment; filename=" + fileName;
                    this.response.reset();
                    this.response.setContentType("APPLICATION/OCTET-STREAM");
                    this.response.setHeader("Content-Disposition", headStr);
                    this.response.setHeader("x-frame-options", "SAMEORIGIN");
                    ServletOutputStream out = this.response.getOutputStream();
                    workbook.write((OutputStream)out);
                    log.info("\u5bfc\u51fa\u6210\u529f,sheetName:{}", (Object)this.sheetName);
                }
                catch (IOException e) {
                    log.info("ExportExcelUtil export IOException\u5f02\u5e38:{},\u5f02\u5e38\u5806\u6808:{}", (Object)e.getMessage(), (Object)e);
                    log.info("\u5bfc\u51fa\u5931\u8d25sheetName:{}", (Object)this.sheetName);
                }
            }
        }
        catch (Exception e) {
            log.info("ExportExcelUtil export\u5f02\u5e38:{},\u5f02\u5e38\u5806\u6808:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportAndUpdateTask(FileTaskPo fileTaskPo, StreamingExportExcelUtil<?> excelUtil, FileTaskServiceRpc fileTaskServiceRpc, String moduleName) {
        OutputStream out = null;
        ByteArrayInputStream in = null;
        try {
            BigDecimal process = null;
            while (true) {
                if ((process = StreamingExportExcelUtil.getExportPercentageProcess((Object)fileTaskPo.getTaskId())).compareTo(new BigDecimal(0)) < 0) {
                    fileTaskPo.setFileStatus(Long.valueOf(-1L));
                    fileTaskServiceRpc.update(fileTaskPo);
                    break;
                }
                if (process.compareTo(new BigDecimal(1)) == 0) {
                    fileTaskPo.setFileStatus(Long.valueOf(99L));
                    fileTaskServiceRpc.update(fileTaskPo);
                    out = new ByteArrayOutputStream();
                    excelUtil.exportToOutputStream(out);
                    in = new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
                    QiNiuUtil niuUtil = new QiNiuUtil();
                    String bucket = ((QiNiuConfig)SpringContextHolder.getApplicationContext().getBean(QiNiuConfig.class)).getBucketNm();
                    QiNiuVo qiniuUrl = niuUtil.upload(bucket, (InputStream)in, FileNameUtil.getExportStoreFileName((String)moduleName));
                    fileTaskPo.setFileStatus(Long.valueOf(100L));
                    String domain = ((QiNiuConfig)SpringContextHolder.getApplicationContext().getBean(QiNiuConfig.class)).getDomain();
                    fileTaskPo.setFileUnl(domain + "/" + qiniuUrl.getUrl().toString());
                    fileTaskPo.setModifiedDate(new Date());
                    fileTaskServiceRpc.update(fileTaskPo);
                    break;
                }
                fileTaskPo.setFileStatus(Long.valueOf(process.multiply(new BigDecimal(100)).longValue()));
                fileTaskServiceRpc.update(fileTaskPo);
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            log.info("ExportExcelUtil exportAndUpdateTask\u5f02\u5e38:{},\u5f02\u5e38\u5806\u6808:{}", (Object)e.getMessage(), (Object)e);
            fileTaskPo.setFileStatus(Long.valueOf(-1L));
            fileTaskServiceRpc.update(fileTaskPo);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.info("ExportExcelUtil exportAndUpdateTask out IOException\u5f02\u5e38:{},\u5f02\u5e38\u5806\u6808:{}", (Object)e.getMessage(), (Object)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.info("ExportExcelUtil exportAndUpdateTask in IOException\u5f02\u5e38:{},\u5f02\u5e38\u5806\u6808:{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    public CellStyle getColumnTopStyle(Workbook workbook) {
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)11);
        font.setBoldweight((short)700);
        font.setFontName("Courier New");
        CellStyle style = workbook.createCellStyle();
        style.setBorderBottom((short)1);
        style.setBottomBorderColor((short)8);
        style.setBorderLeft((short)1);
        style.setLeftBorderColor((short)8);
        style.setBorderRight((short)1);
        style.setRightBorderColor((short)8);
        style.setBorderTop((short)1);
        style.setTopBorderColor((short)8);
        style.setFont(font);
        style.setWrapText(false);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        return style;
    }

    public CellStyle getStyle(Workbook workbook) {
        Font font = workbook.createFont();
        font.setFontName("Courier New");
        CellStyle style = workbook.createCellStyle();
        style.setBorderBottom((short)1);
        style.setBottomBorderColor((short)8);
        style.setBorderLeft((short)1);
        style.setLeftBorderColor((short)8);
        style.setBorderRight((short)1);
        style.setRightBorderColor((short)8);
        style.setBorderTop((short)1);
        style.setTopBorderColor((short)8);
        style.setFont(font);
        style.setWrapText(false);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        return style;
    }
}

