/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.common.utils;

import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.kotlin.KotlinFile;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.VisitableElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.internal.util.StringUtility;

public class DefaultCommentGenerator
implements CommentGenerator {
    private final Properties properties = new Properties();
    private boolean suppressDate = false;
    private boolean suppressAllComments = false;
    private boolean addRemarkComments = false;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private FullyQualifiedJavaType generatedImport = new FullyQualifiedJavaType("jakarta.annotation.Generated");

    public void addComment(XmlElement xmlElement) {
        if (this.suppressAllComments) {
            return;
        }
        xmlElement.addElement((VisitableElement)new TextElement("<!--"));
        StringBuilder sb = new StringBuilder();
        sb.append("  WARNING - \u53ea\u8bfb - ");
        sb.append("@mbg.generated");
        xmlElement.addElement((VisitableElement)new TextElement(sb.toString()));
        xmlElement.addElement((VisitableElement)new TextElement("-->"));
    }

    public void addConfigurationProperties(Properties props) {
        String dateFormatString;
        this.properties.putAll((Map<?, ?>)props);
        this.suppressDate = StringUtility.isTrue((String)this.properties.getProperty("suppressDate"));
        this.suppressAllComments = StringUtility.isTrue((String)this.properties.getProperty("suppressAllComments"));
        this.addRemarkComments = StringUtility.isTrue((String)this.properties.getProperty("addRemarkComments"));
        if (StringUtility.isTrue((String)this.properties.getProperty("useLegacyGeneratedAnnotation"))) {
            this.generatedImport = new FullyQualifiedJavaType("javax.annotation.Generated");
        }
        if (StringUtility.stringHasValue((String)(dateFormatString = this.properties.getProperty("dateFormat")))) {
            this.dateFormat = new SimpleDateFormat(dateFormatString);
        }
    }

    protected void addJavadocTag(JavaElement javaElement, boolean markAsDoNotDelete) {
        javaElement.addJavaDocLine(" *");
        StringBuilder sb = new StringBuilder();
        sb.append(" * ");
        sb.append("@mbg.generated");
        if (markAsDoNotDelete) {
            sb.append(" do_not_delete_during_merge");
        }
        javaElement.addJavaDocLine(sb.toString());
    }

    public void addClassComment(InnerClass innerClass, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        innerClass.addJavaDocLine("/**");
        sb.append(" * \u53ea\u8bfb. ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        innerClass.addJavaDocLine(sb.toString());
        this.addJavadocTag((JavaElement)innerClass, false);
        innerClass.addJavaDocLine(" */");
    }

    public void addClassComment(InnerClass innerClass, IntrospectedTable introspectedTable, boolean markAsDoNotDelete) {
        if (!this.suppressAllComments) {
            StringBuilder sb = new StringBuilder();
            innerClass.addJavaDocLine("/**");
            innerClass.addJavaDocLine(sb.toString());
            this.addJavadocTag((JavaElement)innerClass, false);
            innerClass.addJavaDocLine(" */");
        }
    }

    public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (!this.suppressAllComments && this.addRemarkComments) {
            topLevelClass.addJavaDocLine("import io.swagger.annotations.ApiModelProperty;");
            topLevelClass.addJavaDocLine("import io.swagger.annotations.ApiModel;");
            topLevelClass.addJavaDocLine("/**");
            topLevelClass.addJavaDocLine(" * \u53ea\u8bfb. ");
            topLevelClass.addJavaDocLine(" */");
            topLevelClass.addJavaDocLine("@ApiModel(value = \"" + introspectedTable.getFullyQualifiedTable() + "\")");
        }
    }

    public void addEnumComment(InnerEnum innerEnum, IntrospectedTable introspectedTable) {
        if (!this.suppressAllComments) {
            StringBuilder sb = new StringBuilder();
            innerEnum.addJavaDocLine("/**");
            innerEnum.addJavaDocLine(" * This enum was generated by MyBatis Generator.");
            sb.append(" * This enum corresponds to the database table ");
            sb.append(introspectedTable.getFullyQualifiedTable());
            innerEnum.addJavaDocLine(sb.toString());
            this.addJavadocTag((JavaElement)innerEnum, false);
            innerEnum.addJavaDocLine(" */");
        }
    }

    public void addFieldComment(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (this.suppressAllComments) {
            return;
        }
        field.addJavaDocLine("/**");
        String remarks = introspectedColumn.getRemarks();
        field.addJavaDocLine(" * \u53ea\u8bfb. " + introspectedColumn.getRemarks() + ". " + introspectedColumn.getActualColumnName());
        this.addJavadocTag((JavaElement)field, false);
        field.addJavaDocLine(" */");
        String swaggerName = field.getName();
        String swaggerValue = remarks;
        String swagger = "@ApiModelProperty(value = \"" + swaggerValue + "\",name = \"" + swaggerName + "\")";
        field.addJavaDocLine(swagger);
    }

    public void addFieldComment(Field field, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        field.addJavaDocLine("/**");
        sb.append(" * \u53ea\u8bfb. ");
        field.addJavaDocLine(sb.toString());
        this.addJavadocTag((JavaElement)field, false);
        field.addJavaDocLine(" */");
    }

    public void addGeneralMethodComment(Method method, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments) {
            return;
        }
        method.addJavaDocLine("/**");
        method.addJavaDocLine(" * \u53ea\u8bfb. ");
        this.addJavadocTag((JavaElement)method, false);
        method.addJavaDocLine(" */");
    }

    public void addGetterComment(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        method.addJavaDocLine("/**");
        sb.append(" * \u53ea\u8bfb. ");
        method.addJavaDocLine(sb.toString());
        this.addJavadocTag((JavaElement)method, false);
        method.addJavaDocLine(" */");
    }

    public void addSetterComment(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        method.addJavaDocLine("/**");
        sb.append(" * \u53ea\u8bfb. ");
        method.addJavaDocLine(sb.toString());
        this.addJavadocTag((JavaElement)method, false);
        method.addJavaDocLine(" */");
    }

    public void addRootComment(XmlElement rootElement) {
    }

    public void addGeneralMethodAnnotation(Method method, IntrospectedTable introspectedTable, Set<FullyQualifiedJavaType> imports) {
        imports.add(this.generatedImport);
        String comment = "Source Table: " + introspectedTable.getFullyQualifiedTable().toString();
        method.addAnnotation(this.getGeneratedAnnotation(comment));
    }

    public void addGeneralMethodAnnotation(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn, Set<FullyQualifiedJavaType> imports) {
        imports.add(this.generatedImport);
        String comment = "Source field: " + introspectedTable.getFullyQualifiedTable().toString() + "." + introspectedColumn.getActualColumnName();
        method.addAnnotation(this.getGeneratedAnnotation(comment));
    }

    public void addFieldAnnotation(Field field, IntrospectedTable introspectedTable, Set<FullyQualifiedJavaType> imports) {
        imports.add(this.generatedImport);
        String comment = "Source Table: " + introspectedTable.getFullyQualifiedTable().toString();
        field.addAnnotation(this.getGeneratedAnnotation(comment));
    }

    public void addFieldAnnotation(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn, Set<FullyQualifiedJavaType> imports) {
        imports.add(this.generatedImport);
        String comment = "Source field: " + introspectedTable.getFullyQualifiedTable().toString() + "." + introspectedColumn.getActualColumnName();
        field.addAnnotation(this.getGeneratedAnnotation(comment));
        if (!this.suppressAllComments && this.addRemarkComments) {
            String remarks = introspectedColumn.getRemarks();
            if (this.addRemarkComments && StringUtility.stringHasValue((String)remarks)) {
                String[] remarkLines;
                field.addJavaDocLine("/**4");
                field.addJavaDocLine(" * Database Column Remarks:");
                String[] var8 = remarkLines = remarks.split(System.getProperty("line.separator"));
                int var9 = remarkLines.length;
                for (int var10 = 0; var10 < var9; ++var10) {
                    String remarkLine = var8[var10];
                    field.addJavaDocLine(" *   " + remarkLine);
                }
                field.addJavaDocLine(" */");
            }
        }
    }

    public void addClassAnnotation(InnerClass innerClass, IntrospectedTable introspectedTable, Set<FullyQualifiedJavaType> imports) {
        imports.add(this.generatedImport);
        String comment = "Source Table: " + introspectedTable.getFullyQualifiedTable().toString();
        innerClass.addAnnotation(this.getGeneratedAnnotation(comment));
    }

    private String getGeneratedAnnotation(String comment) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("@Generated(");
        if (this.suppressAllComments) {
            buffer.append('\"');
        } else {
            buffer.append("value=\"");
        }
        buffer.append(MyBatisGenerator.class.getName());
        buffer.append('\"');
        if (!this.suppressDate && !this.suppressAllComments) {
            buffer.append(", date=\"");
            buffer.append(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now()));
            buffer.append('\"');
        }
        if (!this.suppressAllComments) {
            buffer.append(", comments=\"");
            buffer.append(comment);
            buffer.append('\"');
        }
        buffer.append(')');
        return buffer.toString();
    }

    public void addFileComment(KotlinFile kotlinFile) {
        if (!this.suppressAllComments) {
            kotlinFile.addFileCommentLine("/*");
            kotlinFile.addFileCommentLine(" * Auto-generated file. Created by MyBatis Generator");
            if (!this.suppressDate) {
                kotlinFile.addFileCommentLine(" * Generation date: " + DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now()));
            }
            kotlinFile.addFileCommentLine(" */");
        }
    }
}

