/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    public static final String ymdhms = "yyyy-MM-dd HH:mm:ss";
    public static final String ymdhmsS = "yyyy-MM-dd HH:mm:ss SSS";
    private static final String ymd = "yyyy-MM-dd";
    private final String year = "yyyy";
    private final String month = "MM";
    private final String day = "dd";
    public static final long DATEMM = 86400L;

    public String getCurrentTime() {
        SimpleDateFormat yyyyMmDdHhMmSs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return yyyyMmDdHhMmSs.format(new Date());
    }

    public static boolean hourMinuteBetween(Date start, Date end) throws Exception {
        Date now = new Date();
        long nowTime = now.getTime();
        long startTime = start.getTime();
        long endTime = end.getTime();
        return nowTime <= endTime;
    }

    public static String getStrDateByDay(String backDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, Integer.parseInt("-" + backDay));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String back = sdf.format(calendar.getTime());
        return back;
    }

    public static String getStrDateByMonth(String backMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, Integer.parseInt("-" + backMonth));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String back = sdf.format(calendar.getTime());
        return back;
    }

    public static String getSpecifiedDayBeforeString(String sDate, int before) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date formatDate = null;
        try {
            formatDate = format.parse(sDate);
        }
        catch (ParseException e) {
            log.error("\u5f02\u5e38\uff1a", (Throwable)e);
        }
        c.setTime(formatDate);
        int day = c.get(5);
        c.set(5, day - before);
        return format.format(c.getTime());
    }

    public static int differentDaysByMillisecond(String date1String, String date2String) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date1 = null;
        Date date2 = null;
        try {
            date1 = format.parse(date1String);
            date2 = format.parse(date2String);
        }
        catch (ParseException e) {
            log.error("\u5f02\u5e38:", (Throwable)e);
        }
        if (date2 != null) {
            int days = (int)((date2.getTime() - date1.getTime()) / 86400000L) + 1;
            return days;
        }
        return 0;
    }

    public static Date getSpecifiedDayBefore(Date date, int before) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = format.format(date);
        Date formatDate = null;
        try {
            formatDate = format.parse(sDate);
        }
        catch (ParseException e) {
            log.error("\u5f02\u5e38\uff1a", (Throwable)e);
        }
        c.setTime(formatDate);
        int day = c.get(5);
        c.set(5, day - before);
        return c.getTime();
    }

    public String getCurrentYear() {
        SimpleDateFormat yearSdf = new SimpleDateFormat("yyyy");
        return yearSdf.format(new Date());
    }

    public String getCurrentMonth() {
        SimpleDateFormat monthSdf = new SimpleDateFormat("MM");
        return monthSdf.format(new Date());
    }

    public String getCurrentDay() {
        SimpleDateFormat daySdf = new SimpleDateFormat("dd");
        return daySdf.format(new Date());
    }

    public String getCurrentymd() {
        SimpleDateFormat ymdSdf = new SimpleDateFormat("yyyy-MM-dd");
        return ymdSdf.format(new Date());
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long getTimeNumberToday() {
        Date date = new Date();
        SimpleDateFormat yyyyMmDd = new SimpleDateFormat("yyyy-MM-dd");
        String str = yyyyMmDd.format(date);
        try {
            date = yyyyMmDd.parse(str);
            return date.getTime() / 1000L;
        }
        catch (ParseException e) {
            log.error("\u5f02\u5e38\uff1a", (Throwable)e);
            return 0L;
        }
    }

    public static String getTodateString() {
        SimpleDateFormat yyyymmddhhNot = new SimpleDateFormat("yyyyMMdd");
        String str = yyyymmddhhNot.format(new Date());
        return str;
    }

    public static Date getYesterDayZeroHour(int amount) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, amount);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal.getTime();
    }

    public static Date getStartDateOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal.getTime();
    }

    public static Date getEndDateOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(13, 59);
        cal.set(12, 59);
        cal.set(11, 23);
        return cal.getTime();
    }

    public static String longToString(long date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date dt2 = new Date(date * 1000L);
        String sDateTime = sdf.format(dt2);
        return sDateTime;
    }

    public static Date getTodayZeroHour() {
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal.getTime();
    }

    public static Date getYesterDay24Hour() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        cal.set(13, 59);
        cal.set(12, 59);
        cal.set(11, 23);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date stringToDate(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getStartDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 7);
        date = c.getTime();
        return date;
    }

    public static Date getStartDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.add(2, 1);
        c.add(5, -1);
        date = c.getTime();
        return date;
    }

    public static Date getStartDayOfNextMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, 1);
        c.set(5, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfNextMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.add(2, 2);
        c.add(5, -1);
        date = c.getTime();
        return date;
    }

    public static String givedTimeToBefer(String givedTime, long interval, String formatDateSign) {
        String tomorrow = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(formatDateSign);
            Date gDate = sdf.parse(givedTime);
            long current = gDate.getTime();
            long beforeOrAfter = current - interval * 1000L;
            Date date = new Date(beforeOrAfter);
            tomorrow = new SimpleDateFormat(formatDateSign).format(date);
        }
        catch (ParseException e) {
            log.error("\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return tomorrow;
    }

    public static long stringToLong(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date dt2 = null;
        long lTime = 0L;
        try {
            dt2 = sdf.parse(date);
            lTime = dt2.getTime() / 1000L;
        }
        catch (ParseException e) {
            log.error("\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return lTime;
    }

    public Map<String, String> getTwoDay(String endTime, String beginTime, boolean isEndTime) {
        Map<String, String> result = new HashMap<String, String>();
        if (endTime == null || "".equals(endTime) || beginTime == null || "".equals(beginTime)) {
            return null;
        }
        try {
            SimpleDateFormat ymdSdf = new SimpleDateFormat("yyyy-MM-dd");
            Date date = ymdSdf.parse(endTime);
            endTime = ymdSdf.format(date);
            Date mydate = ymdSdf.parse(beginTime);
            long day = (date.getTime() - mydate.getTime()) / 86400000L;
            result = DateUtil.getDate((String)endTime, (Integer)Integer.parseInt(day + ""), (boolean)isEndTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public Integer getTwoDayInterval(String endTime, String beginTime, boolean isEndTime) {
        if (endTime == null || "".equals(endTime) || beginTime == null || "".equals(beginTime)) {
            return 0;
        }
        long day = 0L;
        try {
            SimpleDateFormat ymdSdf = new SimpleDateFormat("yyyy-MM-dd");
            Date date = ymdSdf.parse(endTime);
            endTime = ymdSdf.format(date);
            Date mydate = ymdSdf.parse(beginTime);
            day = (date.getTime() - mydate.getTime()) / 86400000L;
        }
        catch (Exception e) {
            return 0;
        }
        return Integer.parseInt(day + "");
    }

    public static Map<String, String> getDate(String endTime, Integer interval, boolean isEndTime) {
        HashMap<String, String> result = new HashMap<String, String>();
        if ((interval == 0 || isEndTime) && isEndTime) {
            result.put(endTime, endTime);
        }
        if (interval > 0) {
            int begin;
            for (int i = begin = 0; i < interval; ++i) {
                endTime = DateUtil.givedTimeToBefer((String)endTime, (long)86400L, (String)"yyyy-MM-dd");
                result.put(endTime, endTime);
            }
        }
        return result;
    }

    public List<Long> getDatesBetweenTwoDate(String beginDate, String endDate) throws ParseException {
        SimpleDateFormat ymdSdf = new SimpleDateFormat("yyyy-MM-dd");
        Date bDate = ymdSdf.parse(beginDate);
        Date eDate = ymdSdf.parse(endDate);
        ArrayList<Long> lDate = new ArrayList<Long>();
        lDate.add(bDate.getTime());
        Calendar cal = Calendar.getInstance();
        cal.setTime(bDate);
        boolean bContinue = true;
        while (bContinue) {
            cal.add(5, 1);
            if (!eDate.after(cal.getTime())) break;
            lDate.add(cal.getTime().getTime());
        }
        lDate.add(eDate.getTime());
        return lDate;
    }

    public static String format(Date date, String pattern) {
        String returnValue = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(date);
        }
        return returnValue;
    }

    public static Date parse(String strDate, String pattern) {
        if (StringUtils.isEmpty((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            log.error("\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    public static String interceptFormat(String strDate, String originPattern, String newPattern) {
        if (StringUtils.isEmpty((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(newPattern);
        return df.format(DateUtil.stringToDate((String)strDate, (String)originPattern));
    }

    public static String interceptFormat(String strDate) {
        if (StringUtils.isEmpty((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(DateUtil.stringToDate((String)strDate, (String)"yyyy-MM-dd HH:mm:ss"));
    }

    public static Date addMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        return cal.getTime();
    }

    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, n);
        return cal.getTime();
    }

    public static Date addHour(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, n);
        return cal.getTime();
    }

    public static Date addMinute(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, n);
        return cal.getTime();
    }

    public static int getIntervalDays(Date date, Date otherDate) {
        long time = Math.abs(date.getTime() - otherDate.getTime());
        return (int)(time / 86400000L);
    }

    public static Long getIntervalMinutes(Date date, Date otherDate) {
        long time = Math.abs(date.getTime() - otherDate.getTime());
        return time == 0L ? 0L : time / 60000L;
    }

    public static Date truncate(Date date, int field) {
        return DateUtils.truncate((Date)date, (int)field);
    }

    public int getDayOfMonth() {
        Calendar aCalendar = Calendar.getInstance(Locale.CHINA);
        int day = aCalendar.getActualMaximum(5);
        return day;
    }

    public static String getNow(String format) {
        return DateUtil.format((Date)new Date(), (String)format);
    }

    public static String getBirthFirst(String year) {
        if (StringUtils.isBlank((CharSequence)year)) {
            year = "0";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        return String.valueOf(Integer.parseInt(format.format(new Date())) - Integer.valueOf(year)) + "-12-31";
    }

    public static String getBirthLast(String year) {
        if (StringUtils.isBlank((CharSequence)year)) {
            year = "100";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        return String.valueOf(Integer.parseInt(format.format(new Date())) - Integer.valueOf(year)) + "-01-01";
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.interceptFormat((String)"2018-05-03 00:00:00", (String)"yyyy-MM-dd HH:mm:ss", (String)"yyyy-MM-dd"));
        System.out.println(DateUtil.format((Date)DateUtil.addDay((Date)new Date(), (int)-3), (String)"yyyy-MM-dd HH:mm:ss"));
    }

    public static String formatDateByPattern(Date date, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = sdf.format(date);
        }
        return formatTimeStr;
    }

    public static String getCronExpression(Date date) {
        String dateFormat = "ss mm HH dd MM ? yyyy";
        return DateUtil.formatDateByPattern((Date)date, (String)dateFormat);
    }

    public static Date getZeroTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date zero = calendar.getTime();
        return zero;
    }
}

