/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponservice.common.utils.QiNiuUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.spire.barcode.BarCodeGenerator;
import com.spire.barcode.BarcodeSettings;
import com.spire.barcode.IBarCodeSettings;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarcodeUtil {
    private static Logger logger = LoggerFactory.getLogger(BarcodeUtil.class);
    private static final String FORMAT_NAME = "PNG";

    public static String generateBarCode(String msg) {
        logger.info("enter BarcodeUtil generateBarCode param:msg:{}", (Object)msg);
        String qiniuUrl = "";
        if (StringUtils.isEmpty((CharSequence)msg)) {
            return qiniuUrl;
        }
        Code128Writer writer = new Code128Writer();
        BitMatrix bitMatrix = writer.encode(msg, BarcodeFormat.CODE_128, 220, 40);
        BufferedImage image = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, FORMAT_NAME, os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            String uuid = UUID.randomUUID().toString().replace("-", "") + ".png";
            qiniuUrl = QiNiuUtil.upload((InputStream)is, (String)uuid);
            os.close();
            ((InputStream)is).close();
        }
        catch (Exception e) {
            logger.info("enter BarcodeUtil generateBarCode Exception:e:{}", (Object)JSONObject.toJSONString((Object)e));
        }
        return qiniuUrl;
    }

    public static String generateQRCode(String msg) {
        logger.info("enter BarcodeUtil generateQRCode param:msg:{}", (Object)msg);
        String qiniuUrl = "";
        if (StringUtils.isEmpty((CharSequence)msg)) {
            return qiniuUrl;
        }
        BarcodeSettings settings = new BarcodeSettings();
        settings.setType(24L);
        settings.setData(msg);
        settings.setShowText(false);
        settings.setQRCodeDataMode(2);
        settings.setX(2.5f);
        settings.setY(2.5f);
        settings.setQRCodeECL(3);
        settings.hasBorder(false);
        settings.setData2D(null);
        settings.setShowTopText(false);
        settings.setShowText(false);
        settings.setBottomMargin(0.0f);
        settings.setTopMargin(0.0f);
        settings.setLeftMargin(0.0f);
        settings.setRightMargin(0.0f);
        BarCodeGenerator barCodeGenerator = new BarCodeGenerator((IBarCodeSettings)settings);
        BufferedImage image = barCodeGenerator.generateImage();
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, FORMAT_NAME, os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            String uuid = UUID.randomUUID().toString().replace("-", "") + ".png";
            qiniuUrl = QiNiuUtil.upload((InputStream)is, (String)uuid);
            os.close();
            ((InputStream)is).close();
        }
        catch (Exception e) {
            logger.info("enter BarcodeUtil generateQRCode Exception:e:{}", (Object)JSONObject.toJSONString((Object)e));
        }
        return qiniuUrl;
    }
}

