/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.common.thread;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ThreadPool
implements InitializingBean {
    @Value(value="${thread.pool.corePoolSize}")
    private int corePoolSize;
    @Value(value="${thread.pool.maxPoolSize}")
    private int maximumPoolSize;
    @Value(value="${thread.pool.queueCapacity}")
    private int queueCapacity;
    @Value(value="${thread.pool.keepAliveSeconds}")
    private long keepAliveSeconds;
    private static ThreadPoolExecutor threadPoolExecutor;
    private static final Logger logger;

    private ThreadPool() {
    }

    public static void run(Runnable runnable) {
        logger.info("ThreadPool>activeCount\uff1a" + threadPoolExecutor.getActiveCount());
        logger.info("ThreadPool>taskCount\uff1a" + threadPoolExecutor.getTaskCount());
        logger.info("ThreadPool>completedTaskCount\uff1a" + threadPoolExecutor.getCompletedTaskCount());
        threadPoolExecutor.execute(runnable);
    }

    public void afterPropertiesSet() throws Exception {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(this.queueCapacity);
        threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveSeconds, TimeUnit.SECONDS, workQueue, new ThreadPoolExecutor.CallerRunsPolicy());
        logger.info("ThreadPool\u521d\u59cb\u5316\u7ebf\u7a0b\u6c60\u5b8c\u6210 workQueue:" + this.queueCapacity);
    }

    public static ThreadPoolExecutor getThreadPoolExecutor() {
        return threadPoolExecutor;
    }

    static {
        logger = LoggerFactory.getLogger(ThreadPool.class);
    }
}

