/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.common.datavo;

import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POIUtil<T> {
    private static final Logger log = LoggerFactory.getLogger(POIUtil.class);
    final Pattern p = Pattern.compile("^//d+(//.//d+)?$");

    public void exportExcel(OutputStream out, String name, JSONArray ja, String tbName, Map<String, String> map, Map<Integer, String> map2) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(name);
        XSSFRow row = sheet.createRow(0);
        int index = 0;
        try {
            HashMap<String, Integer> mapdata = new HashMap<String, Integer>();
            for (Integer in : map2.keySet()) {
                XSSFCell cell = row.createCell(index);
                cell.setCellValue(map2.get(in));
                ++index;
                mapdata.put(map2.get(in), in);
            }
            for (int i = 0; i < ja.length(); ++i) {
                row = sheet.createRow(i + 1);
                JSONObject jaa = ja.getJSONObject(i);
                Iterator iterator1 = jaa.keys();
                int index1 = 0;
                while (iterator1.hasNext()) {
                    String key1 = (String)iterator1.next();
                    if (null == map.get(key1)) continue;
                    String value = jaa.getString(key1);
                    XSSFCell cell = row.createCell((Integer)mapdata.get(map.get(key1)) - 1);
                    cell.setCellValue(value);
                    ++index1;
                }
            }
            workbook.write(out);
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38", (Throwable)e);
        }
    }

    public void exportExcelSting(OutputStream out, String name, JSONArray ja, String tbName, Map<String, String> map) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(name);
        XSSFRow row = sheet.createRow(0);
        int index = 0;
        try {
            JSONObject first = ja.getJSONObject(0);
            Iterator iterator = first.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (null == map.get(key)) continue;
                XSSFCell cell = row.createCell(index);
                cell.setCellValue(map.get(key));
                ++index;
            }
            for (int i = 0; i < ja.length(); ++i) {
                row = sheet.createRow(i + 1);
                JSONObject jaa = ja.getJSONObject(i);
                Iterator iterator1 = jaa.keys();
                int index1 = 0;
                while (iterator1.hasNext()) {
                    String key1 = (String)iterator1.next();
                    if (null == map.get(key1)) continue;
                    String value = jaa.getString(key1);
                    XSSFCell cell = row.createCell(index1);
                    cell.setCellValue(value);
                    ++index1;
                }
            }
            workbook.write(out);
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel(String title, String headers, Collection<Object> storeVos, OutputStream out, String pattern, HSSFWorkbook workbook) {
        HSSFSheet sheet = workbook.getSheet(title);
        sheet.setDefaultColumnWidth(15);
        HSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor((short)40);
        style.setFillPattern((short)1);
        style.setBorderBottom((short)1);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderTop((short)1);
        style.setAlignment((short)2);
        HSSFFont font = workbook.createFont();
        font.setColor((short)20);
        font.setFontHeightInPoints((short)12);
        font.setBoldweight((short)700);
        style.setFont(font);
        HSSFCellStyle style2 = workbook.createCellStyle();
        style2.setFillForegroundColor((short)43);
        style2.setFillPattern((short)1);
        style2.setBorderBottom((short)1);
        style2.setBorderLeft((short)1);
        style2.setBorderRight((short)1);
        style2.setBorderTop((short)1);
        style2.setAlignment((short)2);
        style2.setVerticalAlignment((short)1);
        HSSFFont font2 = workbook.createFont();
        font2.setBoldweight((short)400);
        style2.setFont(font2);
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        HSSFComment comment = patriarch.createComment((HSSFAnchor)new HSSFClientAnchor(0, 0, 0, 0, 4, 2, 6, 5));
        comment.setString((RichTextString)new HSSFRichTextString("\u53ef\u4ee5\u5728POI\u4e2d\u6dfb\u52a0\u6ce8\u91ca\uff01"));
        comment.setAuthor("leno");
        HSSFRow row = sheet.createRow(0);
        int j = 0;
        for (String string : headers.split(",")) {
            HSSFCell cell = row.createCell(j);
            ++j;
            cell.setCellStyle(style);
            HSSFRichTextString text = new HSSFRichTextString(string);
            cell.setCellValue((RichTextString)text);
        }
        Iterator<Object> it = storeVos.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            Object t = it.next();
            Field[] fields = t.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                HSSFCell cell = row.createCell(i);
                cell.setCellStyle(style2);
                Field field = fields[i];
                String fieldName = field.getName();
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value instanceof Boolean) {
                        boolean bValue = (Boolean)value;
                        textValue = "\u7537";
                        if (!bValue) {
                            textValue = "\u5973";
                        }
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                        textValue = sdf.format(date);
                    } else if (value instanceof byte[]) {
                        row.setHeightInPoints(60.0f);
                        sheet.setColumnWidth(i, 2856);
                        byte[] bsValue = (byte[])value;
                        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 1023, 255, 6, index, 6, index);
                        anchor.setAnchorType(2);
                        patriarch.createPicture(anchor, workbook.addPicture(bsValue, 5));
                    } else {
                        String string = textValue = value == null ? "" : value.toString();
                    }
                    if (textValue == null) continue;
                    Matcher matcher = this.p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    HSSFRichTextString richString = new HSSFRichTextString(textValue);
                    HSSFFont font3 = workbook.createFont();
                    font3.setColor((short)12);
                    richString.applyFont((Font)font3);
                    cell.setCellValue((RichTextString)richString);
                }
                catch (SecurityException e) {
                    log.error("\u5f02\u5e38:", (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    log.error("\u5f02\u5e38:", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    log.error("\u5f02\u5e38:", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error("\u5f02\u5e38:", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error("\u5f02\u5e38:", (Throwable)e);
                }
                continue;
            }
        }
    }
}

