package com.bizvane.couponfacade.interfaces;

import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;
import java.util.Map;

@FeignClient(value="${feign.client.coupon.name}",path="${feign.client.coupon.path}/integralActivity")
@Api("积分商城活动")
public interface IntegralActivityServiceFeign {


  /**
   * @author Ngp
   * @date 2021/11/3
   * @description 积分商城不限店活动券效果查询
   **/
  @ApiOperation(value = "积分商场不限店活动券效果查询", notes = "积分商场不限店活动券效果查询", tags = {"积分商城查询接口"},httpMethod = "POST")
  @RequestMapping(value="/NS/getIntegralActivityCouponAnalyseSub", method = RequestMethod.POST)
  ResponseData<Map<String,GetIntegralActivityCouponAnalyseResponseVO>>
      getIntegralActivityCouponAnalyseSub(@RequestBody @Valid GetIntegralActivityCouponAnalyseRequestVO requestVO);



}
