package com.bizvane.couponfacade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author zcc
 * @date 2020/9/21 11:04
 * 券作废请求Vo
 **/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CouponInvalidRequestVO implements Serializable {
    private static final long serialVersionUID = -4822299732619867923L;
    @ApiModelProperty(value = "品牌id", name = "brandId", required = false, example = "")
    private Long brandId;

    @ApiModelProperty(value = "企业id", name = "companyId", required = false, example = "")
    private Long companyId;

    @ApiModelProperty(value = "会员code", name = "memberCode", required = false, example = "")
    private String memberCode;

    @ApiModelProperty(value = "发送类型", name = "sendType", required = false, example = "")
    private String sendType;

    @ApiModelProperty(value = "业务id集合", name = "sendBussienIdList", required = false, example = "")
    private List<Long> sendBussienIdList;

    @ApiModelProperty(value = "发券时间起始时间", name = "sendTimeStartDate", required = false, example = "")
    private Date sendTimeStartDate;


}
