package com.bizvane.couponfacade.enums;

import com.bizvane.members.facade.enums.OpenCardChannelEnum;

/**
 * @Author liramon
 * @Date 2020/10/27 14:24
 * @Description
 * @Version 1.0
 */
public enum ListTypeEnum {

    COUPON_LIST_TYPE_16("16", "自动营销任务"),

    COUPON_LIST_TYPE_1("1", "手动发券任务"),

    COUPON_LIST_TYPE_2("2", "会员活动"),

    COUPON_LIST_TYPE_3("3", "会员任务"),

    COUPON_LIST_TYPE_4("4", "智能营销"),

    COUPON_LIST_TYPE_5("5", "会员分组运营"),

    COUPON_LIST_TYPE_7("7", "积分商城"),

    COUPON_LIST_TYPE_8("8", "导购发卷"),

    COUPON_LIST_TYPE_10("10", "员工卷"),

    COUPON_LIST_TYPE_11("12", "天猫卷"),

    COUPON_LIST_TYPE_13("13", "渠道卷");

    private String code;

    private String msg;

    ListTypeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    /**
     * 根据枚举code获得枚举msg
     *
     * @param code
     * @return
     */
    public static String getMsgByCode(String code) {
        for (ListTypeEnum type : ListTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type.getMsg();
            }
        }
        return "";
    }
}
