package com.bizvane.couponfacade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SendCouponsUrSimpleRequestVO {

    @ApiModelProperty(
            value = "会员卡号",
            name = "cardNo",
            required = false,
            example = ""
    )
    private String cardNo;
    @ApiModelProperty(
            value = "手机号",
            name = "phone",
            required = false,
            example = ""
    )
    private String phone;
    @ApiModelProperty(
            value = "unionId",
            name = "unionId",
            required = false,
            example = ""
    )
    private String unionId;
    @ApiModelProperty(
            value = "券定义id",
            name = "couponDefinitionId",
            required = false,
            example = ""
    )
    private List<Long> couponDefinitionId;
    @ApiModelProperty(
            value = "品牌号",
            name = "brandCode",
            required = false,
            example = ""
    )
    private String brandCode;
    @ApiModelProperty(
            value = "企业id",
            name = "sysCompanyId"
    )
    private Long sysCompanyId;
    @ApiModelProperty(
            value = "发券类型",
            name = "sendType"
    )
    private String sendType;

    @ApiModelProperty(
            value = "发券数量",
            name = "couponCount"
    )
    private List<Integer> couponCount;

    @ApiModelProperty(
            value = "业务订单号",
            name = "serviceOrder"
    )
    private String serviceOrder;
}

