package com.bizvane.couponfacade.models.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.validation.constraints.NotNull;


/**
 * @author baofeng@zhidemai.com
 * @createTime 2023-03-29 13:22:15
 * @description: 企微导购送券列表查询请求对象
 */
@ApiModel(value = "企微导购送券列表查询请求对象")
@Data
@NoArgsConstructor
@AllArgsConstructor(access = AccessLevel.PACKAGE)
@Builder
public class StaffSendCouponListRequestVO {

    @ApiModelProperty(name = "sysCompanyId", value = "企业ID", required = false, example = "1L")
    private Long sysCompanyId;

    @ApiModelProperty(name = "sysBrandId", value = "品牌ID", required = false, example = "1L")
    private Long sysBrandId;

    @NotNull(message = "送券渠道来源不允许为空")
    @ApiModelProperty(name = "couponChannelSource", value = "送券渠道来源,1-侧边栏聊天送券", required = true, example = "1")
    private Integer couponChannelSource;

    @NotNull(message = "导购Code不允许为空")
    @ApiModelProperty(name = "staffCode", value = "导购Code", required = true, example = "")
    private String staffCode;

    @ApiModelProperty(name = "isReceived", value = "是否已领取，1-是，0-否", example = "")
    private Integer isReceived;

    @ApiModelProperty(name = "pageNo", value = "当前页数", required = false, example = "1")
    private Integer pageNo = 1;

    @ApiModelProperty(name = "pageSize", value = "显示条数", required = false, example = "10")
    private Integer pageSize = 10;

}