package com.bizvane.couponfacade.models.vo;

import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * @author baofeng@zhidemai.com
 * @createTime 2023-03-29 13:43:22
 * @description: 企微导购送券列表查询结果对象
 */
@ApiModel(value = "企微导购送券列表查询结果对象")
@Data
@NoArgsConstructor
@AllArgsConstructor(access = AccessLevel.PACKAGE)
@Builder
public class StaffSendCouponListResponseVO {

    @ApiModelProperty(name = "sysCompanyId", value = "企业ID", required = false, example = "1L")
    private Long sysCompanyId;

    @ApiModelProperty(name = "sysBrandId", value = "品牌ID", required = false, example = "1L")
    private Long sysBrandId;

    @ApiModelProperty(name = "couponName", value = "券名称", example = "")
    private String couponName;

    @ApiModelProperty(name = "couponMoney", value = "券面额", example = "")
    private BigDecimal couponMoney;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty(name = "sendTime", value = "赠送时间", example = "")
    private Date sendTime;

    @ApiModelProperty(name = "couponStatue", value = "券状态，19-未领取（商秀导购侧边栏发券新增状态），20-未使用(已领取)，25-已过期，30-已核销", example = "")
    private Integer couponStatue;

    @ApiModelProperty(name = "memberCode", value = "会员Code", example = "")
    private String memberCode;

    @ApiModelProperty(name = "memberName", value = "会员名称", example = "")
    private String memberName;

    @ApiModelProperty(name = "externalName", value = "好友名称", example = "")
    private String externalName;

    @ApiModelProperty(name = "esMbrFriendsId", value = "好友表主键ID", example = "")
    private Long esMbrFriendsId;

    @ApiModelProperty(value = "券定义对象")
    private CouponDefinitionPOWithBLOBs couponDefinitionPO;


}