package com.bizvane.couponfacade.models.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author dingShiChen
 * @since 2019/6/25
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("创建预生成券任务VO/异业卷生产任务VO")
public class PreGeneratedCouponTaskCreateVO implements Serializable {

	private static final long serialVersionUID = -5070020116531697108L;

	@ApiModelProperty(value = "券定义id", required = true)
	private Long couponDefinitionId;

	@ApiModelProperty(value = "任务名称", required = true)
	private String taskName;

	@ApiModelProperty(value = "发券总数量", required = true)
	private Integer totalNumber;

	@ApiModelProperty(value = "授权品牌id", required = false)
	private Long empowerBrandId;

}
