package com.bizvane.couponfacade.models.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author zcc
 * @date 2022/10/21 14:30
 **/

@Data
public class CouponQuotaSendDetailAppletVo implements Serializable {
    private static final long serialVersionUID = 7021568612494588310L;

    /**
     * 配额发送详情id
     */
    private Long couponQuotaSendDetailId;

    /**
     * 配额详情id
     */
    private Long couponQuotaDetailId;

    /**
     * 配额id
     */
    private Long couponQuotaId;

    /**
     * 券定义id
     */
    private Long couponDefinitionId;

    /**
     * 企业id
     */
    private Long sysCompanyId;

    /**
     * 品牌id
     */
    private Long sysBrandId;

    /**
     * 员工code
     */
    private String staffCode;

    /**
     * 发送会员code集合
     */
    private String memberCodeList;

    /**
     * 券名称
     */
    private String couponName;

    /**
     * 面额
     */
    private BigDecimal money;

    /**
     * 折扣
     */
    private Long discount;

    /**
     * 最低消费金额(满减金额)
     */
    private BigDecimal minConsume;

    /**
     * 券说明
     */
    private String info;

    /**
     * 优惠类型（1现金，2折扣，3礼品）
     */
    private Byte preferentialType;

    /**
     * 有效期开始时间
     */
    private Date validDateStart;

    /**
     * 有效期结束时间
     */
    private Date validDateEnd;

    /**
     * 发送状态1-待发送;2-待领取;3-已领取
     */
    private Integer sendStatus;

    /**
     * 手动领取截止时间
     */
    private Date getCouponEndTime;

    /**
     *
     */
    private Boolean valid;

}
