package com.bizvane.couponfacade.interfaces;

import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponQuotaSendDetailPO;
import com.bizvane.couponfacade.models.vo.*;
import com.bizvane.couponfacade.mq.OnlineCouponUseEvent;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;

import java.util.List;

@FeignClient(value="${feign.client.coupon.name}",path="${feign.client.coupon.path}/couponRpc")
@Api("券管理")
public interface CouponServiceFeign {


  /**
   * 根据券号使用优惠券接口(核销)
   * @param requestVO
   * @return
   */
  @ApiOperation(value = "根据券号使用优惠券接口(核销)", notes = "根据券号使用优惠券接口", tags = {"券操作接口"},httpMethod = "POST")
  @RequestMapping(value="/use", method = RequestMethod.POST)
  ResponseData<String> use(@RequestBody(required = false) CouponUseVO requestVO);

  /**
   * 企业微信券核销
   * @param requestVO
   * @return
   */
  @ApiOperation(value = "企业微信券核销", notes = "企业微信券核销", tags = {"券操作接口"},httpMethod = "POST")
  @RequestMapping(value="/wechatEnterpriseUse", method = RequestMethod.POST)
  ResponseData<String> wechatEnterpriseUse(@RequestBody(required = false) CouponUseVO requestVO);


  /**
   * 线上使用优惠券
   * @param vo
   * @return
   */
  @ApiOperation(value = "线上使用优惠券接口", notes = "线上使用优惠券接口", tags = {"券消息配置"},httpMethod = "POST")
  @RequestMapping(value="/onlineUse", method = RequestMethod.POST)
  ResponseData<Object> onlineUse(@RequestBody CouponOnlineUseRequestVO vo);

  /**
   * 线下使用优惠券
   * @param vo
   * @return
   */
  @ApiOperation(value = "线下使用优惠券接口", notes = "线下使用优惠券接口", tags = {"券消息配置"},httpMethod = "POST")
  @RequestMapping(value="/offlineUse", method = RequestMethod.POST)
  ResponseData<Object> offlineUse(@RequestBody CouponOfflineUseRequestVO vo);
  /**
  * 泰迪熊消费所有积分券
  * */
  @ApiOperation(value = "泰迪积分券核销(定制服务)", notes = "泰迪积分券核销(定制服务)", tags = {"券操作接口"}, httpMethod = "POST")
  @PostMapping("/taiDiIntegralCouponUse")
  ResponseData<Long> taiDiIntegralCouponAllUse(@RequestBody CouponOfflineUseRequestVO vo);
  /**
   * 冲正券接口
   * @param vo
   * @return
   */
  @ApiOperation(value = "冲正券接口", notes = "冲正券接口", tags = {"券消息配置"},httpMethod = "POST")
  @RequestMapping(value="/cancelUse", method = RequestMethod.POST)
  ResponseData<Object> cancelUse(@RequestBody CouponCancelUseRequestVO vo);

  /**
   * 冲正券接口，只处理线上
   * @param vo
   * @return
   */
  @ApiOperation(value = "线上冲正券接口", httpMethod = "POST")
  @RequestMapping(value="/cancelUseOnline", method = RequestMethod.POST)
  ResponseData<Object> cancelUseOnline(@RequestParam("couponCode") String couponCode);

  /**
   * 冲正券接口，处理线上以及线下
   * @param vo
   * @return
   */
  @ApiOperation(value = "线上冲正券并写线下接口", httpMethod = "POST")
  @RequestMapping(value="/cancelUseOnlineAndSyncOffline", method = RequestMethod.POST)
  ResponseData<Object> cancelUseOnlineAndSyncOffline(@RequestParam("couponCode") String couponCode);

  /**
   * 转赠
   * @param vo
   * @return
   */
  @ApiOperation(value = "转赠券接口", notes = "转赠券接口", tags = {"券实例接口"},httpMethod = "POST")
  @ApiImplicitParams({
          @ApiImplicitParam(name = "couponCode", value = "券code", required = true, dataType = "String"),
          @ApiImplicitParam(name = "oldMemberCode", value = "旧会员code", required = true, dataType = "String"),
          @ApiImplicitParam(name = "newMemberCode", value = "新会员code", required = true, dataType = "String"),
          @ApiImplicitParam(name = "useBusinessCode", value = "业务code", required = true, dataType = "String")
  })
  @RequestMapping(value="/givenCoupon", method = RequestMethod.POST)
  ResponseData<Integer> givenCoupon(@RequestBody CouponEntityVO vo);


  /**
   * 转赠状态更改为转赠中
   * @return
   */
  @ApiOperation(value = "转赠状态更改为转赠中", notes = "转赠状态更改为转赠中", tags = {"券实例接口"},httpMethod = "POST")
  @ApiImplicitParams({
          @ApiImplicitParam(name = "couponCode", value = "券code", required = true, dataType = "String")
  })
  @RequestMapping(value="/couponGiving", method = RequestMethod.POST)
  ResponseData couponGiving(@RequestParam("couponCode")String couponCode,@RequestParam("memberCode")String memberCode,
                                        @RequestParam("companyId")Long companyId,@RequestParam("brandId")Long brandId, @RequestParam(value="transferDate",required = false)String transferDate);


    /**
     * 券转赠撤回
     * @return
     */
    @ApiOperation(value = "券转赠撤回", notes = "券转赠撤回", tags = {"券实例接口"},httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "couponCode", value = "券code", required = true, dataType = "String")
    })
    @RequestMapping(value="/transferCouponBack", method = RequestMethod.POST)
    ResponseData transferCouponBack(@RequestParam("couponCode")String couponCode,@RequestParam("memberCode")String memberCode,
                                       @RequestParam("companyId")Long companyId,@RequestParam("brandId")Long brandId);

  /**
   * 锁定
   * @param vo
   * @return
   */
  @ApiOperation(value = "锁定券接口", notes = "锁定券接口", tags = {"券实例接口"},httpMethod = "POST")
  @ApiImplicitParams({
          @ApiImplicitParam(name = "couponCode", value = "券code", required = true, dataType = "String"),
          @ApiImplicitParam(name = "memberCode", value = "会员code", required = true, dataType = "String")
  })
  @RequestMapping(value="/lock", method = RequestMethod.POST)
  ResponseData<Object> lock(@RequestBody CouponEntityVO vo);


  /**
   * 未锁定
   * @param vo
   * @return
   */
  @ApiOperation(value = "解锁券接口", notes = "解锁券接口", tags = {"券实例接口"},httpMethod = "POST")
  @ApiImplicitParams({
          @ApiImplicitParam(name = "couponCode", value = "券code", required = true, dataType = "String"),
          @ApiImplicitParam(name = "memberCode", value = "会员code", required = true, dataType = "String")
  })
  @RequestMapping(value="/unlock", method = RequestMethod.POST)
  ResponseData<Object> unlock(@RequestBody CouponEntityVO vo);

  /**
   * 券过期
   * @param vo
   * @return
   */
  @ApiOperation(value = "优惠券到期接口", notes = "优惠券到期接口", tags = {"券消息配置"},httpMethod = "POST")
  @ApiImplicitParams({
          @ApiImplicitParam(name = "couponCode", value = "券code", required = true, dataType = "String"),
          @ApiImplicitParam(name = "memberCode", value = "会员code", required = true, dataType = "String"),
          @ApiImplicitParam(name = "useBusinessCode", value = "使用业务code", required = true, dataType = "String"),
          @ApiImplicitParam(name = "sysBrandId", value = "品牌id", required = true, dataType = "Long"),
  })
  @RequestMapping(value="/couponExpire", method = RequestMethod.POST)
  ResponseData<Object> couponExpire(@RequestBody CouponEntityVO vo);


  @ApiOperation(value = "线下核销券(标准接口)", notes = "线下核销券",httpMethod = "POST")
  @RequestMapping(value="/offlineSyncCoupon", method = RequestMethod.POST)
  ResponseData offlineSyncCoupon(@RequestBody CouponOfflineUseRequestVO vo);

  /**
   * 券冲正
   * @param vo
   * @return
   */
  @ApiOperation(value = "券冲正(标准接口)", notes = "券冲正",httpMethod = "POST")
  @RequestMapping(value="/reversal", method = RequestMethod.POST)
  ResponseData reversal(CouponReversalRequestVO vo);


  /**
   * 根据券号初始化券的使用状态,并插入券冲正记录表(退单的退券操作)
   *
   * @param couponRefundRequestVO
   * @return
   */
  @ApiOperation(value = "根据券号初始化券的使用状态(退单的退券操作)", notes = "根据券号初始化券的使用状态(退单的退券操作)", tags = {"券操作接口"}, httpMethod = "POST")
  @RequestMapping(value="/refund", method = RequestMethod.POST)
  ResponseData<String> refund(@RequestBody CouponRefundRequestVO couponRefundRequestVO);

  /**
   * 优惠券作废操作
   *
   * @param couponInvalidRequestVO
   * @return
   */
  @ApiOperation(value = "优惠券作废操作", notes = "优惠券作废操作", tags = {"优惠券作废操作"}, httpMethod = "POST")
  @RequestMapping(value="/invalid", method = RequestMethod.POST)
  ResponseData<String> invalid(@RequestBody CouponInvalidRequestVO couponInvalidRequestVO);


  @ApiOperation(value = "微商城门店装修优惠券列表接口", notes = "微商城门店装修优惠券列表接口", tags = {"微商城门店装修优惠券列表接口"}, httpMethod = "GET")
  @GetMapping("/activityCoupon")
  ResponseData activityCoupon(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("page") Integer page, @RequestParam("pageSize") Integer pageSize);


  @ApiOperation(value = "活动优惠券领取状态", notes = "活动优惠券领取状态接口", tags = {"活动优惠券领取状态接口"}, httpMethod = "POST")
  @PostMapping("/getCouponReceiveStatus")
  ResponseData getCouponReceiveStatus(@RequestBody ReceiveCouponStatusVO receiveCouponStatusVO);


  @ApiOperation(value = "获取其他品牌的异业卷", notes = "获取其他品牌的异业卷接口", tags = {"获取其他品牌的异业卷接口"}, httpMethod = "POST")
  @PostMapping("/getOtherBrandDifindustryCoupon")
  ResponseData<PageInfo<CouponEntityAndDefinitionVO>> getOtherBrandDifindustryCoupon(@RequestBody CouponListByMemberCodeRequestVO vo);


//  @ApiOperation(value = "会员注册发放异业卷", notes = "会员注册发放异业卷接口", tags = {"会员注册发放异业卷接口"}, httpMethod = "POST")
//  @PostMapping("/registerSendDifindustryCoupon")
//  ResponseData<Boolean> registerSendDifindustryCoupon(@RequestBody CouponListByMemberCodeRequestVO vo);
//
//
//  @ApiOperation(value = "异业券扣减数量实例接口",tags = {"异业券扣减数量实例接口"})
//  @RequestMapping(value = "/reduceQuantity",method = RequestMethod.POST)
//  ResponseData<String> reduceQuantity(@RequestBody @Valid CouponDifindustryQuantityRecordVO recordVO);


  /**
   * 异业券批量查询剩余数量实例接口
   * @param list 必传:manualId 选传:couponDefinitionId、sysCompanyId
   * @return
   */
  @ApiOperation(value = "异业券批量查询剩余数量实例接口",tags = {"异业券批量查询剩余数量实例接口"})
  @RequestMapping(value = "/getSurplusQuantityByList",method = RequestMethod.POST)
  ResponseData<List<CouponDefinitionVO>> getSurplusQuantityByList(@RequestBody List<CouponDefinitionVO> list);


  /**
   * 查询异业券详情
   * @param couponDifindustrySendDetailId
   * @return
   */
  @ApiOperation(value = "查询异业券详情实例接口",tags = {"查询异业券详情实例接口"})
  @RequestMapping(value = "/findBySendIdRpc",method = RequestMethod.POST)
  ResponseData<CouponDefinitionPO> findBySendIdRpc(@RequestParam("couponDifindustrySendDetailId") Long couponDifindustrySendDetailId);

  /**
   * 查询异业券详情实例
   * @param couponDifindustrySendDetailId
   * @return
   */
  @ApiOperation(value = "查询异业券详情实例接口",tags = {"查询异业券详情实例接口"})
  @RequestMapping(value = "/findCouponBySendIdRpc",method = RequestMethod.POST)
  ResponseData<CouponDetailResponseVO> findCouponBySendIdRpc(@RequestParam("couponDifindustrySendDetailId") Long couponDifindustrySendDetailId);


  /**
   * 统计活动发异业卷数量
   * @param vo
   * @return
   */
  @RequestMapping(value = "/getDifindustryAnalysisByBusinessIdList", method = RequestMethod.POST)
  ResponseData<List<CouponDifindustryVO>> getDifindustryAnalysisByBusinessIdList(@RequestBody CouponDifindustryVO vo);


  /**
   * 获取异业异业企业券的来源品牌
   * @param vo
   * @return
   */
  @RequestMapping(value = "getDifindustryCouponSourceBrand",method = RequestMethod.POST)
  ResponseData<List<CouponDifindustryVO>> getDifindustryCouponSourceBrand(@RequestBody CouponManualVO vo);


  /**
   * 查询活动/任务发送异业券的会员列表
   * @param requestVO
   * @return
   */
  @RequestMapping(value = "findCouponSendMemberList",method = RequestMethod.POST)
  ResponseData<PageInfo<CouponSendMemberListResponseVO>> findCouponSendMemberList(@RequestBody CouponSendMemberListRequestVO requestVO);




  @ApiOperation(value = "券同步接口", notes = "券同步接口", tags = {"券同步接口"}, httpMethod = "POST")
  @PostMapping("/couponSynchronize")
  ResponseData couponSynchronize(@RequestBody CouponOfflineCreateResponseVO couponOfflineCreateResponseVO);

  /**
   * 361线上使用优惠券
   * @param msgVO
   * @return
   */
  @ApiOperation(value = "361使用优惠券接口", notes = "361使用优惠券接口",httpMethod = "POST")
  @RequestMapping(value="/onlineUse361", method = RequestMethod.POST)
  ResponseData<String> onlineUse361(@RequestBody OnlineCouponUseEvent.OnlineCouponUseVO msgVO);

  @ApiOperation(value = "商秀调用:根据券发送记录ID查询券发送详情接口", notes = "商秀调用:根据券发送记录ID查询券发送详情接口", httpMethod = "POST")
  @ApiImplicitParams({
          @ApiImplicitParam(name = "getCouponQuotaSendDetailById", value = "券发送记录ID", required = true, dataType = "Long")
  })
  @ResponseBody
  @RequestMapping(value = "/getCouponQuotaSendDetailById", method = RequestMethod.POST)
  ResponseData<CouponQuotaSendDetailVO> getCouponQuotaSendDetailById(@RequestParam("couponQuotaSendDetailId") Long couponQuotaSendDetailId);

  @ApiOperation(value = "商秀调用:保存券发送记录接口", notes = "商秀调用:保存券发送记录接口", httpMethod = "POST")
  @PostMapping("/saveCouponQuotaSendDetail")
  ResponseData<Long> saveCouponQuotaSendDetail(@RequestBody SendCouponQuotaBatchRequestVO vo);

  @ApiOperation(value = "商秀调用:扣减额度,送券,更新券发送状态接口", notes = "商秀调用:扣减额度,送券,更新券发送状态接口", httpMethod = "POST")
  @PostMapping("/sendCoupon")
  ResponseData<String> sendCoupon(@RequestBody SendCouponQuotaBatchRequestVO vo);


  @ApiOperation(value = "会员中心调用:根据券发送记录ID查询券发送详情接口", notes = "会员中心调用:根据券发送记录ID查询券发送详情接口", httpMethod = "POST")
  @ApiImplicitParams({
          @ApiImplicitParam(name = "getCouponQuotaSendDetailAppletVoById", value = "券发送记录ID", required = true, dataType = "Long")
  })
  @RequestMapping(value = "/getCouponQuotaSendDetailAppletVoById", method = RequestMethod.POST)
  ResponseData<CouponQuotaSendDetailAppletVo> getCouponQuotaSendDetailAppletVoById(@RequestParam("couponQuotaSendDetailId") Long couponQuotaSendDetailId);

}
