/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponfacade.enums;

import com.bizvane.couponfacade.enums.SendTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum CouponSendTypeEnum {
    MANUAL_SEND_TASK(1, "\u624b\u52a8\u53d1\u5238\u4efb\u52a1", Arrays.asList("85", "110")),
    MEMBER_ACTIVITIES(2, "\u4f1a\u5458\u6d3b\u52a8", Arrays.asList("10", "15", "30", "35", "45", "50", "55", "56", "90", "100", "103", "104", "105", "106", "107", "108", "109", "045", "055")),
    MEMBER_TASK(3, "\u4f1a\u5458\u4efb\u52a1", Arrays.asList("60", "65", "70", "75", "80", "79", "78", "81")),
    MKT_SMART(4, "\u667a\u80fd\u8425\u9500", Arrays.asList("95")),
    MKT_MEMBER_GROUP(5, "\u4f1a\u5458\u5206\u7ec4\u8fd0\u8425", Arrays.asList("94")),
    POINTS_MALL(7, "\u79ef\u5206\u5546\u57ce", Arrays.asList("101", "127")),
    GUIDE_COUPON(8, "\u5bfc\u8d2d\u53d1\u5238", Arrays.asList("102")),
    STAFF_COUPON(10, "\u5458\u5de5\u5238", Arrays.asList("111")),
    OFFLINE_COUPON(11, "\u7ebf\u4e0b\u5238", Arrays.asList("115")),
    TMALL_COUPON(12, "\u5929\u732b\u5238", Arrays.asList("120")),
    CHANNEL_COUPON(13, "\u6e20\u9053\u9886\u5238", Arrays.asList("125")),
    AUTO_MARK_TASK(16, "\u81ea\u52a8\u8425\u9500\u4efb\u52a1", Arrays.asList("130")),
    DIF_FINDUSTRY_COUPON(17, "\u5f02\u4e1a\u5377", Arrays.asList(SendTypeEnum.SEND_COUPON_DIF.getCode())),
    ALIPAY_VOUCHER_COUPON(18, "\u652f\u4ed8\u5b9d\u5546\u5bb6\u5238", Arrays.asList(SendTypeEnum.SEND_ALIPAY_VOUCHER.getCode()));

    private Integer code;
    private String message;
    private List<String> detailTypes;

    private CouponSendTypeEnum(Integer code, String message, List<String> detailTypes) {
        this.code = code;
        this.message = message;
        this.detailTypes = detailTypes;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<String> getDetailTypes() {
        return this.detailTypes;
    }

    public void setDetailTypes(List<String> detailTypes) {
        this.detailTypes = detailTypes;
    }

    public static List<Integer> getMktTypeList() {
        List collect = Arrays.stream(CouponSendTypeEnum.values()).filter(f -> !f.code.equals(CouponSendTypeEnum.TMALL_COUPON.code) && !f.code.equals(CouponSendTypeEnum.STAFF_COUPON.code)).collect(Collectors.toList());
        return collect.stream().map(CouponSendTypeEnum::getCode).collect(Collectors.toList());
    }

    public static List<String> getMktDetailTypeList() {
        List collect = Arrays.stream(CouponSendTypeEnum.values()).filter(f -> !f.code.equals(CouponSendTypeEnum.TMALL_COUPON.code) && !f.code.equals(CouponSendTypeEnum.STAFF_COUPON.code)).collect(Collectors.toList());
        ArrayList<String> result = new ArrayList<String>();
        for (CouponSendTypeEnum couponSendTypeEnum : collect) {
            result.addAll(couponSendTypeEnum.getDetailTypes());
        }
        return result;
    }

    public static List<String> getDetailTypeList(Integer code) {
        CouponSendTypeEnum[] couponSendTypeEnumArray = CouponSendTypeEnum.values();
        int n = couponSendTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            CouponSendTypeEnum value = couponSendTypeEnumArray[n2];
            if (value.code.equals(code)) {
                return value.getDetailTypes();
            }
            ++n2;
        }
        return new ArrayList<String>();
    }

    public static List<String> getDetailTypeList(List<Integer> codes) {
        ArrayList<String> result = new ArrayList<String>();
        for (Integer code : codes) {
            result.addAll(CouponSendTypeEnum.getDetailTypeList(code));
        }
        return result;
    }

    public static String getMessage(String detailType) {
        CouponSendTypeEnum[] couponSendTypeEnumArray = CouponSendTypeEnum.values();
        int n = couponSendTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            CouponSendTypeEnum value = couponSendTypeEnumArray[n2];
            for (String type : value.getDetailTypes()) {
                if (!type.equals(detailType)) continue;
                return value.getMessage();
            }
            ++n2;
        }
        return "";
    }

    public static Integer getCode(String detailType) {
        CouponSendTypeEnum[] couponSendTypeEnumArray = CouponSendTypeEnum.values();
        int n = couponSendTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            CouponSendTypeEnum value = couponSendTypeEnumArray[n2];
            for (String type : value.getDetailTypes()) {
                if (!type.equals(detailType)) continue;
                return value.getCode();
            }
            ++n2;
        }
        return 666;
    }
}

