package com.bizvane.couponfacade.models.vo;
/*
 * Created by JiangWenjian on 2021-04-28.
 */

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author jiangwenjian
 * @version 0.0.1
 * @since 0.0.1 2021-04-28
 */
@Data
public class YzCouponDefinitionVo {

    @ApiModelProperty(value = "绑定的三方活动id", name = "activityId", required = false, example = "")
    private Long activityId;
    @ApiModelProperty(value = "是否同步至微信(默认为false)", name = "isWeixinSync", required = false, example = "")
    private Boolean isWeixinSync;
    @ApiModelProperty(value = "卡包背景色名称", name = "colorName", required = false, example = "")
    private String colorName;
    @ApiModelProperty(value = "卡包背景色值", name = "colorValue", required = false, example = "")
    private String colorValue;
    @ApiModelProperty(value = "客服电话", name = "servicePhone", required = false, example = "")
    private String  servicePhone;
    @ApiModelProperty(value = "卡包标题", name = "servicePhone", required = false, example = "")
    private String  weixinTitle;
    @ApiModelProperty(value = "卡包副标题", name = "weixinSubTitle", required = false, example = "")
    private String  weixinSubTitle;
    @ApiModelProperty(value = "适用的商品分组Id列表", name = "applicableOnlineGoodsGroupIds", required = false, example = "")
    private List<Long> applicableOnlineGoodsGroupIds;
    @ApiModelProperty(value = "  适用的网店商品id", name = "applicableOnlineGoodsIds", required = false, example = "")
    private List<Long> applicableOnlineGoodsIds;
    @ApiModelProperty(value = "适用的网店商品范围类型0:该渠道商品不可用1:不限制2:部分可用3:", name = "applicableOnlineGoodsRangeType", required = false, example = "")
    private Integer applicableOnlineGoodsRangeType;
    @ApiModelProperty(value = " 适用的店铺ids按照前端排序入库", name = "applicableShopIds", required = false, example = "")
    private List<Long> applicableShopIds;
    @ApiModelProperty(value = "适用的店铺范围类型1：仅本店铺可用（默认值）2：部分店铺可用3：全部店铺可用。注意：微商城单店此参数可以不传，默认是当前店铺，如果是连锁场景，则此参数必填", name = "applicableShopRangeType", required = false, example = "")
    private Integer applicableShopRangeType;
    @ApiModelProperty(value = " 是否禁止叠加优惠", name = "isForbidOverlayPreferential", required = true, example = "")
    private Boolean isForbidOverlayPreferential;
    @ApiModelProperty(value = "最大折扣上限单位是分0代表没有折扣上限(默认值) 必填", name = "maxDiscountAmount", required = true, example = "")
    private Integer maxDiscountAmount;
    @ApiModelProperty(value = "使用门槛0：无门槛（默认值）n：门槛值（单位：分）", name = "thresholdAmount", required = true, example = "")
    private Long thresholdAmount;
    @ApiModelProperty(value = "随机券面额范围上限（单位：分）", name = "maxValue", required = true, example = "")
    private Long  maxValue;
    @ApiModelProperty(value = "随机券面额范围下限（单位：分）", name = "minValue", required = true, example = "")
    private Long  minValue;
    @ApiModelProperty(value = "编辑时不可修改优惠方式1：代金券 2:折扣券 必填", name = "preferentialMode", required = true, example = "")
    private Integer preferentialMode;
    @ApiModelProperty(value = "编辑时不可修改相对有效期开始生效时间间隔（天）", name = "relativeValidTimeBeginInterval", required = true, example = "")
    private Integer relativeValidTimeBeginInterval;
    @ApiModelProperty(value = "编辑时不可修改相对有效期持续时间（天）", name = "applicableShopIds", required = true, example = "")
    private Integer relativeValidTimeDuration;
    @ApiModelProperty(value = "编辑时不可修改有效期生成类型1：绝对时间（absoluteValidStartTime~absoluteValidEndTime）2：相对时间（从relativeValidTimeEffectInterval天开始，relativeValidTimeDuration天内有效", name = "applicableShopIds", required = true, example = "")
    private Integer validTimeGenerateType;
    @ApiModelProperty(value = "面额生成规则类型1:固定值==>value字段（默认值）2:指定值==>指定范围为minValue~maxValue之间3:范围随机==>随机范围为minValue~maxValue之间4:无指定值(例如：兑换券)==>value==0", name = "applicableShopIds", required = true, example = "")
    private Integer voucherValueGenerateType;
    @ApiModelProperty(value = "编辑时不可修改优惠面额（单位：分）,当折扣券时，8折，value传80", name = "applicableShopIds", required = true, example = "")
    private Long value;
    @ApiModelProperty(value = "是否配置过期提醒(默认为false)", name = "applicableShopIds", required = true, example = "")
    private Boolean isExpireNotice;
    @ApiModelProperty(value = "过期前几天提醒", name = "applicableShopIds", required = true, example = "")
    private Integer expireNoticeDays;
    @ApiModelProperty(value = "隐藏设置，隐藏优惠券推广链接（隐藏后优惠券无“推广链接”）true-隐藏，false-不隐藏，默认为false", name = "isForbidPublicTake", required = true, example = "")
    private Boolean isForbidPublicTake;
    @ApiModelProperty(value = "公开设置，是否支持优惠券允许公开领取，true-允许，false-不允许，默认为false", name = "applicableShopIds", required = true, example = "")
    private Boolean  isPublicDisplay;
    @ApiModelProperty(value = "是否允许分享活动(默认为false)", name = "applicableShopIds", required = true, example = "")
    private Boolean isSharable;
    @ApiModelProperty(value = "店铺id", name = "authorityId", required = true, example = "")
    private String authorityId;
    @ApiModelProperty(value = " 操作人账号id  必填", name = "authorityId", required = true, example = "")
    private String operatorId;
    @ApiModelProperty(value = "操作账号类型，1:有赞账号id，2:内部员工统一账号id 必填", name = "authorityId", required = true, example = "")
    private String  operatorType;
    @ApiModelProperty(value = "活动备注", name = "remark", required = true, example = "")
    private String remark;
    @ApiModelProperty(value = "活动标题", name = "title", required = true, example = "")
    private String title;
    @ApiModelProperty(value = "来源应用，填写diy应用名 必填 ", name = "title", required = true, example = "")
    private String appName;
    @ApiModelProperty(value = "来源应用，", name = "description", required = true, example = "")
    private String description;
    @ApiModelProperty(value = "编辑时不可修改绝对有效期开始时间，精确到秒", name = "description", required = true, example = "")
    private String absoluteValidStartTime;
    @ApiModelProperty(value = "编辑时不可修改绝对有效期结束时间，精确到秒", name = "description", required = true, example = "")
    private String absoluteValidEndTime;
    @ApiModelProperty(value = "是否同步到微信支付商家券，不传默认false", name = "description", required = true, example = "")
    private Boolean isWechatPaymchsync;

}
