package com.bizvane.couponfacade.interfaces;

import com.bizvane.members.facade.es.pojo.MembersInfoSearchPojo;
import com.bizvane.members.facade.vo.MemberCouponExpireRequestVo;
import com.bizvane.messagebase.model.po.MsgCoupontimePO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;

@FeignClient(value="${feign.client.coupon.name}",path="${feign.client.coupon.path}/couponExpireRpc")
@Api(value = "过期卷券会员实例接口",tags = {"过期卷券会员实例接口"})
public interface CouponExpireServiceFeign {

    @RequestMapping(value = "/selectCouponExpireMember",method = RequestMethod.POST)
    ResponseData<PageInfo<MembersInfoSearchPojo>> selectCouponExpireMember(@RequestBody @Valid MemberCouponExpireRequestVo memberCouponExpireRequestVo);


    @RequestMapping(value = "/selectDefaultExpireDay",method = RequestMethod.GET)
    ResponseData<MsgCoupontimePO> selectDefaultExpireDay(@RequestParam(value = "sysCompanyId",required = false) Long sysCompanyId,
                                                         @RequestParam(value = "sysBrandId",required = false) Long sysBrandId);

}
