package com.bizvane.couponfacade.interfaces;

import com.bizvane.couponfacade.models.bo.CouponDefReq361BO;
import com.bizvane.couponfacade.models.po.CouponOrderEntityPO;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.models.po.CouponDefinitionMoneyPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.vo.CouponDefinitionListQueryVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import io.swagger.annotations.Api;
/**
 * @author bizvane
 */
@FeignClient(value="${feign.client.coupon.name}",path="${feign.client.coupon.path}/couponDefinitionRpc")
@Api(value = "券定义管理",tags = {"券定义管理"})
public interface CouponDefinitionServiceFeign {

    /**
     * 券定义列表接口
     * @param vo
     * @return
     */
    @ApiOperation(value = "获取券定义列表接口",notes = "获取券定义列表接口",tags = {"券定义接口"},httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "sysBrandId", value = "品牌id", required = true, dataType = "Long"),
    })
    @RequestMapping(value="/getList", method = RequestMethod.POST)
    ResponseData<PageInfo<CouponDefinitionPO>> getListRpc(@RequestBody CouponDefinitionListQueryVO vo);

    /**
     * 添加券定义
     * @param po
     * @return
     */
    @ApiOperation(value = "券保存", notes = "券保存", tags = {"定义券"},httpMethod = "POST")
    @PostMapping(value="/add")
    public ResponseData<Long> addRpc(@RequestBody CouponDefinitionPOWithBLOBs po);

    /**
     * 修改券定义接口
     * @param po
     * @return
     */
    @ApiOperation(value = "修改券定义接口",notes = "修改券定义接口",tags = {"券定义接口"},httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "couponDefinitionId", value = "券定义id", required = true, dataType = "Long"),
            @ApiImplicitParam(name = "status", value = "券状态（1已启用，0已停用）", required = true, dataType = "Boolean")
    })
    @RequestMapping(value="updateById", method = RequestMethod.POST)
    ResponseData<Object> updateByIdRpc(@RequestBody CouponDefinitionPOWithBLOBs po);

    /**
     * 涨红包接口
     * @param po
     * @return
     */
    @ApiOperation(value = "涨红包接口", notes = "涨红包接口", tags = {"涨红包接口"},httpMethod = "POST")
    @ApiImplicitParams({
    	
    	 @ApiImplicitParam(name = "taskId", value = "任务taskId", required = true, dataType = "Long")
    })
    @RequestMapping(value="/definitionMoneyRpc", method = RequestMethod.POST)
    public ResponseData<Object> definitionMoneyRpc(@RequestBody CouponDefinitionMoneyPO po);

    /**
     * 查找单个券定义接口
     * @param couponDefinitionId
     * @return
     */
    @ApiOperation(value = "查找单个券定义接口",notes = "查找单个券定义接口",tags = {"券定义接口"},httpMethod = "POST")
    @RequestMapping(value="findById", method = RequestMethod.POST)
    ResponseData<CouponDefinitionPO> findByIdRpc(@RequestParam("couponDefinitionId") Long couponDefinitionId);
    
    /**
     * 查找单个券定义接口
     * @param couponDefinitionId
     * @return
     */
    @ApiOperation(value = "查找单个券定义接口",notes = "查找单个券定义接口",tags = {"券定义接口"},httpMethod = "POST")
    @RequestMapping(value="findById", method = RequestMethod.POST)
    ResponseData<CouponDefinitionPOWithBLOBs> findByIdRpcNew(@RequestParam("couponDefinitionId") Long couponDefinitionId);


    /**
     * 判断券是否过期
     * @param couponDefinitionId
     * @return
     */
    @ApiOperation(value = "判断券是否过期",notes = "判断券是否过期",tags = {"券定义接口"},httpMethod = "POST")
    @RequestMapping(value="couponDefinitionExpire", method = RequestMethod.POST)
    ResponseData<Boolean> couponDefinitionExpire(@RequestParam("couponDefinitionId") Long couponDefinitionId);



    /**
     * 根据所传传条件判断券是否可用
     * @param po
     * @return
     */
    @ApiOperation(value = "根据所传传条件判断券是否可用",notes = "根据所传传条件判断券是否可用",tags = {"券定义接口"},httpMethod = "POST")
    @RequestMapping(value="verifyCouponRules", method = RequestMethod.POST)
    ResponseData<Boolean> verifyCouponRules(@RequestBody CouponOrderEntityPO po);


    /**
     * 根据券定义id或渠道查询券定义列表
     * @param bo
     * @return
     */
    @ApiOperation(value = "券定义列表查询",notes = "券定义列表查询",tags = {"券定义接口"},httpMethod = "POST")
    @PostMapping(value="queryCouponDefinitionList")
    ResponseData<PageInfo<CouponDefinitionPOWithBLOBs>> queryCouponDefinitionList(@RequestBody CouponDefReq361BO bo);


    /**
     * 查询企业券定义rpc
     *
     * @param sysCompanyId  企业id
     * @param pageNum       页数
     * @param pageSize      每页数量
     *
     * @return              ResponseData<PageInfo<CouponDefinitionPOWithBLOBs>>
     */
    @PostMapping(value="getCouponDefListByCompanyId")
    ResponseData<PageInfo<CouponDefinitionPOWithBLOBs>> getCouponDefListByCompanyId(@RequestParam(value = "sysCompanyId") Long sysCompanyId,
                                                                                    @RequestParam(value = "pageNum") Integer pageNum,
                                                                                    @RequestParam(value = "pageSize") Integer pageSize);
}
