package com.bizvane.couponfacade.interfaces;

import com.bizvane.couponfacade.models.vo.standard.StandardCouponUseRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author xz
 * @date 2020/3/5 10:09
 **/

@FeignClient(value="${feign.client.coupon.name}",path="${feign.client.coupon.path}/standardCouponRpc")
@Api(value = "标准券接口",tags = {"标准券接口"})
public interface StandardCouponServiceFeign {

    @ApiOperation(value = "优惠券核销", notes = "优惠券核销", tags = {"标准接口"},httpMethod = "POST")
    @RequestMapping(value = "/couponUse", method = RequestMethod.POST)
    ResponseData<String> couponUse(StandardCouponUseRequestVo standardCouponUseRequestVo);


}
