package com.bizvane.couponfacade.models.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 退券,初始化Vo
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
public class CouponRefundRequestVO implements Serializable {

      private static final long serialVersionUID = 1L;

      @io.swagger.annotations.ApiModelProperty(value = "所属企业id", name = "sysCompanyId", required = false,example = "")
      private Long sysCompanyId;

      @io.swagger.annotations.ApiModelProperty(value = "品牌code", name = "brandCode", required = false,example = "")
      private String brandCode;

      @io.swagger.annotations.ApiModelProperty(value = "券号集合", name = "couponCodelist", required = false,example = "")
      private List<String> couponCodelist;

      @io.swagger.annotations.ApiModelProperty(value = "订单号", name = "orderNo", required = false, example = "")
      private String orderNo;

      @io.swagger.annotations.ApiModelProperty(value = "门店code", name = "storeCode", required = false,example = "")
      private String storeCode;

}
