package com.bizvane.couponfacade.models.vo;

import com.bizvane.members.facade.vo.MemberInfoSimpleVO;
import com.bizvane.members.facade.vo.MemberInfoVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
@ToString
public class SendCouponBatchRequestVO implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "券定义id", name = "couponDefinitionId", required = false,example = "")
  private Long couponDefinitionId;
  @ApiModelProperty(value = "发送类型(1-立即发送，2-指定时间)", name = "sendType", required = false,example = "")
  private Byte sendType;
  @ApiModelProperty(value = "发券时间" , name = "sendTime" , required = false , example = "")
  private Date sendTime;
  @ApiModelProperty(value = "任务名称" , name = "businessName" , required = false , example = "")
  private String businessName;
  @ApiModelProperty(value = "业务id" , name = "businessId" , required = false , example = "")
  private Long businessId;
  @ApiModelProperty(value = "业务类型" , name = "businessType" , required = false , example = "")
  private String businessType;
  @ApiModelProperty(value = "会员集合(手动发券)", name = "memberList", required = false,example = "")
  private List<MemberInfoSimpleVO> memberListManual;
  //发券数量
  private  Integer totalNumber;
  //手动发券id
  private Long couponManualId;

  @ApiModelProperty(value = "会员集合(营销)", name = "memberList", required = false,example = "")
  private List<MemberInfoVo> memberList;

  @io.swagger.annotations.ApiModelProperty(value = "创建人id",name = "createUserId", required = false,example = "")
  private Long createUserId;

  @io.swagger.annotations.ApiModelProperty(value = "创建人",name = "createUserName", required = false,example = "")
  private String createUserName;


//  企业微信群发新加字段
  @io.swagger.annotations.ApiModelProperty(value = "员工code",name = "staffCode", required = true,example = "")
  private String staffCode;
  @io.swagger.annotations.ApiModelProperty(value = "员工名称",name = "staffName", required = true,example = "")
  private String staffName;
  @io.swagger.annotations.ApiModelProperty(value = "企业id",name = "企业id", required = true,example = "")
  private Long sysCompanyId;
  @io.swagger.annotations.ApiModelProperty(value = "品牌id",name = "品牌id", required = true,example = "")
  private Long sysBrandId;

  @io.swagger.annotations.ApiModelProperty(value = "发送会员数量",name = "发送会员数量", required = true,example = "")
  private String memberNum;
  
  @io.swagger.annotations.ApiModelProperty(value = "券配额表主键",name = "券配额表主键", required = true,example = "")
  private Long couponQuotaId;

  @io.swagger.annotations.ApiModelProperty(value = "券定义id群",name = "券定义id群", required = true,example = "")
  private String couponDefinitionIds;
  
  @io.swagger.annotations.ApiModelProperty(value = "发券一级批次号（系统）",name = "发券二级批次号（系统）", required = true,example = "")
  private String batchSendCode;
  
  @io.swagger.annotations.ApiModelProperty(value = "发券二级批次号（系统）",name = "发券二级批次号（系统）", required = true,example = "")
  private Long batchSendCodeDetail;
  
  @io.swagger.annotations.ApiModelProperty(value = "券类型",name = "空值0:批量  ，  1:预生成）", required = true,example = "")
  private Integer type;

  @io.swagger.annotations.ApiModelProperty(value = "礼包id",name = "礼包id",example = "")
  private Long mktGiftBagId;

  private String bigCategory;//大类
  private String middleCategory;//中类
  private String smallCategory;//小类
  /**
   * 年份
   * */
  private String particularYear;
  /**
   * 季节
   * */
  private String season;

  public String getParticularYear() {
    return particularYear;
  }

  public void setParticularYear(String particularYear) {
    this.particularYear = particularYear;
  }

  public String getSeason() {
    return season;
  }

  public void setSeason(String season) {
    this.season = season;
  }

  public Long getMktGiftBagId() {
    return mktGiftBagId;
  }

  public void setMktGiftBagId(Long mktGiftBagId) {
    this.mktGiftBagId = mktGiftBagId;
  }

  public int getType() {
	return type;
}

public void setType(int type) {
	this.type = type;
}

public int getTotalNumber() {
	return totalNumber;
}

public void setTotalNumber(int totalNumber) {
	this.totalNumber = totalNumber;
}

public Long getCouponManualId() {
	return couponManualId;
}

public void setCouponManualId(Long couponManualId) {
	this.couponManualId = couponManualId;
}

public String getBatchSendCode() {
	return batchSendCode;
}

public void setBatchSendCode(String batchSendCode) {
	this.batchSendCode = batchSendCode;
}

public Long getBatchSendCodeDetail() {
	return batchSendCodeDetail;
}

public void setBatchSendCodeDetail(Long batchSendCodeDetail) {
	this.batchSendCodeDetail = batchSendCodeDetail;
}

public Long getCouponQuotaId() {
	return couponQuotaId;
}

public void setCouponQuotaId(Long couponQuotaId) {
	this.couponQuotaId = couponQuotaId;
}

public String getStaffCode() {
	return staffCode;
}

public void setStaffCode(String staffCode) {
	this.staffCode = staffCode;
}

public String getStaffName() {
	return staffName;
}

public void setStaffName(String staffName) {
	this.staffName = staffName;
}



public Long getSysCompanyId() {
	return sysCompanyId;
}

public void setSysCompanyId(Long sysCompanyId) {
	this.sysCompanyId = sysCompanyId;
}

public Long getSysBrandId() {
	return sysBrandId;
}

public void setSysBrandId(Long sysBrandId) {
	this.sysBrandId = sysBrandId;
}


public String getMemberNum() {
	return memberNum;
}

public void setMemberNum(String memberNum) {
	this.memberNum = memberNum;
}


  public String getBusinessName() {
    return businessName;
  }

  public void setBusinessName(String businessName) {
    this.businessName = businessName;
  }

  public Long getBusinessId() {
    return businessId;
  }

  public void setBusinessId(Long businessId) {
    this.businessId = businessId;
  }

  public Long getCouponDefinitionId() {
    return couponDefinitionId;
  }

  public void setCouponDefinitionId(Long couponDefinitionId) {
    this.couponDefinitionId = couponDefinitionId;
  }

  public String getBusinessType() {
    return businessType;
  }

  public void setBusinessType(String businessType) {
    this.businessType = businessType;
  }

  public Date getSendTime() {
    return sendTime;
  }

  public void setSendTime(Date sendTime) {
    this.sendTime = sendTime;
  }

  public Byte getSendType() {
    return sendType;
  }

  public void setSendType(Byte sendType) {
    this.sendType = sendType;
  }

  public Long getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(Long createUserId) {
    this.createUserId = createUserId;
  }

  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  public List<MemberInfoSimpleVO> getMemberListManual() {
    return memberListManual;
  }

  public void setMemberListManual(List<MemberInfoSimpleVO> memberListManual) {
    this.memberListManual = memberListManual;
  }

  public List<MemberInfoVo> getMemberList() {
    return memberList;
  }

  public void setMemberList(List<MemberInfoVo> memberList) {
    this.memberList = memberList;
  }

  public String getCouponDefinitionIds() {
    return couponDefinitionIds;
  }

  public void setCouponDefinitionIds(String couponDefinitionIds) {
    this.couponDefinitionIds = couponDefinitionIds;
  }

  public String getBigCategory() {
    return bigCategory;
  }

  public void setBigCategory(String bigCategory) {
    this.bigCategory = bigCategory;
  }

  public String getMiddleCategory() {
    return middleCategory;
  }

  public void setMiddleCategory(String middleCategory) {
    this.middleCategory = middleCategory;
  }

  public String getSmallCategory() {
    return smallCategory;
  }

  public void setSmallCategory(String smallCategory) {
    this.smallCategory = smallCategory;
  }
}
