package com.bizvane.couponfacade.models.bo;

import com.bizvane.couponfacade.models.po.OrderDetailInfoPO;
import com.bizvane.couponfacade.models.po.OrderInfoPO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * @author ljc
 * @version 0.0.1
 * @since 0.0.1 2020-05-27
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponOrderAvailableBO implements Serializable {

    /**
     * 品牌code
     */
    private String brandCode;

    /**
     * 会员卡号
     */
    private String cardNo;

    /**
     * 会员唯一标识
     */
    private String erpId;

    /**
     * 会员手机号
     */
    private String phone;

    /**
     * 券可用状态：1可用，2不可用，3全部
     */
    private String availableType;

    /**
     * 订单明细信息
     */
    private ArrayList<OrderDetailInfoPO> orderDetailInfo;

    /**
     * 订单信息
     */
    private OrderInfoPO orderInfo;

    /**
     * 当前页码,默认第一页
     */
    private Integer pageNo = 1;

    /**
     * 每页显示条数,每页最大10条,默认10条
     */
    private Integer pageSize = 10;
}
