package com.bizvane.couponfacade.interfaces;

import com.bizvane.mktcenterservice.models.vo.ActivityManualVO;
import com.bizvane.mktcenterservice.models.vo.CouponRecordVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value="${feign.client.coupon.name}",path="${feign.client.coupon.path}/couponAuthTmallRpc")
@Api(value = "天猫券",tags = {"天猫券"})
public interface CouponAuthTmallServiceFeign {

    /**
     * 领取查询天猫昵称
     * @param requestVO
     * @return
     */
    @ApiOperation(value = "查询天猫昵称接口",notes = "查询天猫昵称接口",tags = {"天猫券"},httpMethod = "POST")
    @RequestMapping(value="/getTaobaoName", method = RequestMethod.POST)
    ResponseData<String> getTaobaoName(@RequestBody ActivityManualVO requestVO);


    /**
     * 兑换查询淘宝昵称
     * @return
     */
    @RequestMapping(value="/getTmallNick", method = RequestMethod.POST)
    ResponseData<String> getTmallNick(@RequestBody CouponRecordVO requestVO);


}
