package com.bizvane.couponfacade.mq;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author dingshichen
 */
public interface OnlineCouponUseEvent {

    String TOPIC_SUFFIX = "online_coupon_use";

    @Data
    class OnlineCouponUseVO {

        @NotNull
        private Long sysCompanyId;

        @NotNull
        private Long sysBrandId;

        //券号
        @NotEmpty
        private String couponCode;

        //核销线下门店
        private String offlineUseStoreId;

        //核销业务单号
        private String useBusinessCode;

        //核销订单金额
        private BigDecimal useBusinessAmount;

        //核销时间
        private Date useTime;
    }
}
