package com.bizvane.couponfacade.models.vo;

import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @author bizvane
 */
@ToString
public class CouponListByMemberCodeRequestVO implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @io.swagger.annotations.ApiModelProperty(value = "品牌id", name = "sysBrandId", required = false,example = "")
  private Long sysBrandId;

  @io.swagger.annotations.ApiModelProperty(value = "公司id", name = "sysCompanyId", required = false,example = "")
  private Long sysCompanyId;

  @io.swagger.annotations.ApiModelProperty(value = "会员号", name = "memberCode", required = false,example = "")
  private String memberCode;

  //兼容vg 小程序新ui多个状态同时查询（0：代表查询全部 1：代表失效  其它状态不变）
  @io.swagger.annotations.ApiModelProperty(value = "券使用状态", name = "couponStatus", required = false,example = "")
  private Byte couponStatus;

  @io.swagger.annotations.ApiModelProperty(value = "显示条数", name = "pageSize")
  private Integer pageSize;

  @io.swagger.annotations.ApiModelProperty(value = "当前页数", name = "page")
  private Integer pageNumber;

    /**
     * 小程序版本号(做版本兼容用)。2020.10.30 此时为 1
     */
  private Integer appEdition;

  private String brandCode;

  private List<String> brandCodeList;

  private List<String> memberCodeList;

  //查询来源默认:中台，0:中台会员 1:小程序 2:商秀
  private Integer querySource;

  public Long getSysCompanyId() {
    return sysCompanyId;
  }

  public void setSysCompanyId(Long sysCompanyId) {
    this.sysCompanyId = sysCompanyId;
  }

  public Long getSysBrandId() {
    return sysBrandId;
  }

  public void setSysBrandId(Long sysBrandId) {
    this.sysBrandId = sysBrandId;
  }

  public String getMemberCode() {
    return memberCode;
  }

  public void setMemberCode(String memberCode) {
    this.memberCode = memberCode;
  }

  public Byte getCouponStatus() {
    return couponStatus;
  }

  public void setCouponStatus(Byte couponStatus) {
    this.couponStatus = couponStatus;
  }

  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  public Integer getPageNumber() {
    return pageNumber;
  }

  public void setPageNumber(Integer pageNumber) {
    this.pageNumber = pageNumber;
  }

  public Integer getAppEdition() {
      return appEdition;
  }

  public void setAppEdition(Integer appEdition) {
      this.appEdition = appEdition;
  }

  public String getBrandCode() {
    return brandCode;
  }

  public void setBrandCode(String brandCode) {
    this.brandCode = brandCode;
  }


  public List<String> getMemberCodeList() {
    return memberCodeList;
  }

  public void setMemberCodeList(List<String> memberCodeList) {
    this.memberCodeList = memberCodeList;
  }

  public Integer getQuerySource() {
    return querySource;
  }

  public void setQuerySource(Integer querySource) {
    this.querySource = querySource;
  }

  public List<String> getBrandCodeList() {
    return brandCodeList;
  }

  public void setBrandCodeList(List<String> brandCodeList) {
    this.brandCodeList = brandCodeList;
  }
}
