package com.bizvane.couponfacade.models.dto;


import lombok.Data;

import java.io.Serializable;

/**
 * 微盟 -》 CRM
 * 微盟修改优惠券的适用门店和适用商品
 */
@Data
public class CouponDefinitionUpdateRequestDto implements Serializable {

    @io.swagger.annotations.ApiModelProperty(value = "券定义id", name = "couponDefinitionId")
    private Long couponDefinitionId;

    @io.swagger.annotations.ApiModelProperty(value = "适用商品类型：1-全部适用，2-部分适用", name = "applianceCommodityType")
    private Integer applianceCommodityType;

    @io.swagger.annotations.ApiModelProperty(value = "商品白名单", name = "commodityWhitelist")
    private String commodityWhitelist;

    @io.swagger.annotations.ApiModelProperty(value = "适用门店类型：1-全部适用，2-部分适用", name = "applianceStoreType")
    private Integer applianceStoreType;

    @io.swagger.annotations.ApiModelProperty(value = "门店白名单", name = "storeWhitelist")
    private String storeWhitelist;
}
