package com.bizvane.couponfacade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ToString
@Data
public class SendCouponAsyncSimpleRequestVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "会员code", name = "memberCode", required = false, example = "")
    private String memberCode;

    @ApiModelProperty(value = "券定义id", name = "couponDefinitionId", required = false, example = "")
    private Long couponDefinitionId;

    @ApiModelProperty(value = "发送类型", name = "sendType", required = false, example = "")
    private String sendType;

    @ApiModelProperty(value = "业务id", name = "sendBussienId", required = false, example = "")
    private Long sendBussienId;

    @ApiModelProperty(value = "任务名称", name = "businessName", required = false, example = "")
    private String businessName;

    @ApiModelProperty(value = "品牌id", name = "brandId", required = false, example = "")
    private Long brandId;

    @NotNull
    @ApiModelProperty(value = "企业id", name = "companyId", required = false, example = "")
    private Long companyId;

    @ApiModelProperty(value = "品牌号", name = "brandCode", required = false, example = "")
    private String brandCode;
    
    @ApiModelProperty(value = "涨红包taskId", name = "taskId", required = false, example = "")
    private String taskId;

    @ApiModelProperty(value = "天猫昵称", name = "tmallNick", required = false, example = "")
    private String tmallNick;

    @ApiModelProperty(value = "本次任务发券数量。例如生日发券共需要发8888张券，则该参数传8888", name = "taskCouponSum", required = true)
    private Integer taskCouponSum;

    @ApiModelProperty(value = "发卷任务id(生成异业券id)", name = "manualId", required = false, example = "")
    private Long manualId;

    @ApiModelProperty(value = "礼包id", name = "mktGiftBagId", required = false, example = "")
    private Long mktGiftBagId;

    @ApiModelProperty(value = "礼包名称", name = "mktGiftBagName", required = false, example = "")
    private String mktGiftBagName;

    @ApiModelProperty(value = "是否为礼包中最后一张券(0否1是)", name = "isGiftBagLastCoupon", required = false, example = "")
    private Byte isGiftBagLastCoupon = 0;

}
