package com.bizvane.couponfacade.models.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.validation.constraints.NotNull;
import java.util.Date;


/**
 * @author baofeng@zhidemai.com
 * @createTime 2023-03-29 13:22:15
 * @description: 侧边栏送券列表查询请求对象
 */
@ApiModel(value = "侧边栏送券列表查询请求对象")
@Data
@NoArgsConstructor
@AllArgsConstructor(access = AccessLevel.PACKAGE)
@Builder
public class CouponQuotaSendDetailListRequestVO {

    @ApiModelProperty(name = "sysCompanyId", value = "企业ID", required = false, example = "1L")
    private Long sysCompanyId;

    @ApiModelProperty(name = "sysBrandId", value = "品牌ID", required = false, example = "1L")
    private Long sysBrandId;

    @NotNull(message = "送券渠道来源不允许为空")
    @ApiModelProperty(name = "couponChannelSource", value = "送券渠道来源,1-侧边栏聊天送券", required = true, example = "1")
    private Integer couponChannelSource;

    @ApiModelProperty(name = "selectedStaffKey", value = "存放导购ID列表的redis key", example = "")
    private String selectedStaffKey;

    @ApiModelProperty(name = "selectedStoreKey", value = "存放店铺ID列表的redis key", example = "")
    private String selectedStoreKey;

    @ApiModelProperty(name = "onlineOrgCodes", value = "线上组织code(英文逗号分割)", example = "")
    private String onlineOrgCodes;

    @ApiModelProperty(name = "couponName", value = "优惠券名称", example = "")
    private String couponName;

    @ApiModelProperty(name = "sendTimeStart", value = "开始赠送时间", example = "")
    private Date sendTimeStart;

    @ApiModelProperty(name = "sendTimeEnd", value = "结束赠送时间", example = "")
    private Date sendTimeEnd;

    @ApiModelProperty(name = "isReceived", value = "是否已领取，1-是，0-否", example = "")
    private Integer isReceived;

    @ApiModelProperty(name = "pageNo", value = "当前页数", required = false, example = "1")
    private Integer pageNo = 1;

    @ApiModelProperty(name = "pageSize", value = "显示条数", required = false, example = "10")
    private Integer pageSize = 10;

}