package com.bizvane.couponfacade.models.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author zcc
 * @date 2022/3/24 22:16
 **/

@Data
public class CouponSendLogBo implements Serializable {
    private static final long serialVersionUID = -4587712512524038300L;

    @ApiModelProperty(value = "主键", name = "couponSendLogId", required = false,example = "")
    private Long couponSendLogId;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId", required = false,example = "")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id", name = "sysBrandId", required = false,example = "")
    private Long sysBrandId;

    @ApiModelProperty(value = "couponCode", name = "couponCode", required = false,example = "")
    private String couponCode;

    @ApiModelProperty(value = "线下券定义code", name = "erpCouponDefinitionCode", required = false,example = "")
    private String erpCouponDefinitionCode;

    @ApiModelProperty(value = "memberCode", name = "memberCode", required = false,example = "")
    private String memberCode;

    @ApiModelProperty(value = "erpId", name = "erpId", required = false,example = "")
    private String erpId;

    @ApiModelProperty(value = "券名称", name = "couponName", required = false,example = "")
    private String couponName;

    @ApiModelProperty(value = "类型", name = "preferentialType", required = false,example = "")
    private Byte preferentialType;

    @ApiModelProperty(value = "金额", name = "money", required = false,example = "")
    private BigDecimal money;

    @ApiModelProperty(value = "折扣", name = "discount", required = false,example = "")
    private BigDecimal discount;

    @ApiModelProperty(value = "发送类型", name = "sendType", required = false,example = "")
    private String sendType;

    @ApiModelProperty(value = "业务名称", name = "businessName", required = false,example = "")
    private String businessName;

    @ApiModelProperty(value = "业务id1", name = "sendBusinessId1", required = false,example = "")
    private String sendBusinessId1;

    @ApiModelProperty(value = "业务id2", name = "sendBusinessId2", required = false,example = "")
    private String sendBusinessId2;

    @ApiModelProperty(value = "任务批次1", name = "couponBatchSendRecordId1", required = false,example = "")
    private String couponBatchSendRecordId1;

    @ApiModelProperty(value = "任务批次2", name = "couponBatchSendRecordId2", required = false,example = "")
    private String couponBatchSendRecordId2;

    @ApiModelProperty(value = "发送状态", name = "sendStatus", required = false,example = "")
    private Integer sendStatus;

    @ApiModelProperty(value = "发送结果信息", name = "sendFlagInfo", required = false,example = "")
    private String sendFlagInfo;

    @ApiModelProperty(value = "发送员工code", name = "sendStaffCode", required = false,example = "")
    private String sendStaffCode;

    @ApiModelProperty(value = "发送时间", name = "sendDate", required = false,example = "")
    private Date sendDate;
}
