package com.bizvane.couponfacade.interfaces;

import com.bizvane.couponfacade.models.vo.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @version 1.0
 * @author: WQK
 * @data: 2022-03-23 12:00
 */
@FeignClient(value="${feign.client.coupon.name}",path="${feign.client.coupon.path}/zdsCouponQueryRpc")
@Api(value = "券查询",tags = {"API"})
public interface ZdsCouponQueryServiceFeign {

    /**
     * 根据券号获取券实例和券定义详情
     * @param couponCode
     * @return
     */
    @ApiOperation(value = "根据券号获取券实例和券定义详情", notes = "根据券号获取券实例和券定义详情", tags = {"券查询接口"},httpMethod = "POST")
    @RequestMapping(value="/findCouponDetailRpc", method = RequestMethod.POST)
    ResponseData<ZdsCouponDetailResponseVO> findCouponDetailRpc(@RequestParam("couponCode") String couponCode,
                                                                            @RequestParam("brandId")Long brandId);



    /**
     * 查询券实例列表(会员erpId条件)
     * @param vo
     * @return
     */
    @ApiOperation(value = "分页查询券实体列表(会员erpId条件)", notes = "分页查询券实体列表(会员erpId条件)", tags = {"券查询接口"},httpMethod = "POST")
    @RequestMapping(value="/getMemberCoupon", method = RequestMethod.POST)
    ResponseData<List<ZdsCouponInfoVo>> zdsGetMemberCoupon(@RequestBody ZdsCouponInfoRequestVO vo);



    /**
     * 分页查询券实体列表(支持会员erpId条件)
     * @param vo
     * @return
     */
    @ApiOperation(value = "分页查询券实体列表(支持会员erpId条件)", notes = "分页查询券实体列表(支持会员erpId条件)", tags = {"券查询接口"},httpMethod = "POST")
    @RequestMapping(value="/getCouponListRpc", method = RequestMethod.POST)
    ResponseData<PageInfo<ZdsCouponInfoVo>> getCouponListRpc(@RequestBody ZdsCouponInfoRequestVO vo);

    /**
     * 根据erpId统计券的使用状况
     * @param erpId
     * @return
     */
    @ApiOperation(value = "根据erpId统计券的使用状况", notes = "根据erpId统计券的使用状况", tags = {"券查询接口"},httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "erpId", value = "erpId", required = false, dataType = "String"),
    })
    @RequestMapping(value="/findCountByErpId", method = RequestMethod.POST)
    ResponseData<CouponFindCouponCountResponseVO> findCountByErpId(@RequestParam(value = "erpId") String erpId, @RequestParam("brandId")Long brandId);


    /**
     * 分页查询券发送记录(支持会员Erp条件)
     * @param vo
     * @return
     */
    @ApiOperation(value = "分页查询券实体列表(支持会员Erp条件)", notes = "分页查询券实体列表(支持会员erpId条件)", tags = {"券查询接口"},httpMethod = "POST")
    @RequestMapping(value="/getCouponInfoLogPage", method = RequestMethod.POST)
    ResponseData<PageInfo<CouponSendLogVo>> getCouponInfoLogPage(@RequestBody ZdsCouponInfoRequestVO vo);

}
