package com.bizvane.couponfacade.models.vo.standard;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author zcc
 * @date 2021/3/23 15:05
 **/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class StandardCouponDefinitionAddVo extends StandardCouponCommonRequireVo implements Serializable {

    private static final long serialVersionUID = 8697188952768829889L;

    /**
     * 券编号. coupon_definition_code
     */
    private String couponDefinitionCode;

    /**
     * 券定义类型：1-线上定义，2-erp生成. coupon_definition_type
     */
    private Byte couponDefinitionType;

    /**
     * 券编号. erp_coupon_definition_code
     */
    private String erpCouponDefinitionCode;

    /**
     * 券名称. coupon_name
     */
    private String couponName;

    /**
     * 渠道限制（1仅线下,2全渠道,3仅线上,4员工券,5天猫券, 6积分券,7商城私有券）. use_channel
     */
    private Byte useChannel;

    /**
     * 优惠类型（1现金，2折扣）. preferential_type
     */
    private Byte preferentialType;

    /**
     * 券的面额. money
     */
    private BigDecimal money;

    /**
     * 券的折扣. discount
     */
    private BigDecimal discount;

    /**
     * 有效期类型：1-日期区间，2-领取后X天有效，3-仅限会员生日当天使用，4-仅限会员生日当月使用 5 领取后X天生效 效期X天. valid_type
     */
    private Byte validType;

    /**
     * 有效期开始时间. valid_date_start
     */
    private Date validDateStart;

    /**
     * 有效期结束时间. valid_date_end
     */
    private Date validDateEnd;

    /**
     * 有效天数. valid_day
     */
    private Integer validDay;

    /**
     * 券模板图片. img
     */
    private String img;

    /**
     * 是否允许叠加（1是，0否）. is_superposition
     */
    private Boolean isSuperposition;

    /**
     * 商品条件限制 允许最大购买件数. goods_condition
     */
    private Integer goodsCondition;

    /**
     * 描述. info
     */
    private String info;

    /**
     * 领取X天后生效. delay_day
     */
    private Integer delayDay;

    /**
     * 领取X天后有效期X天. delay_valid_day
     */
    private Integer delayValidDay;

    /**
     * 适用商品类型：1-全部适用，2-部分适用, 3-商品属性. appliance_commodity_type
     */
    private Byte applianceCommodityType;

    /**
     * 商品单一白名单 commodity_whitelist
     */
    private String commodityWhitelist;

    /**
     * 商品黑名单 commodity_blacklist
     */
    private String commodityBlacklist;

    /**
     * 适用门店类型：1-全部适用，2-部分适用. appliance_store_type
     */
    private Byte applianceStoreType;

    /**
     * 门店白名单 store_whitelist
     */
    private String storeWhitelist;

    /**
     * 门店黑名单 store_blacklist
     */
    private String storeBlacklist;

    /**
     * 适用俱乐部codes
     */
    private String applicableBrandCodes;

    /**
     * 最低消费金额
     */
    private BigDecimal minConsume;

}
