package com.bizvane.couponfacade.models.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 券已转赠VO
 * @author bizvane
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CouponRecordRequestVO implements Serializable{

    private Long sysCompanyId;

    private Long sysBrandId;

    private Integer pageNumber;

    private Integer pageSize;

    private Date startDate;

    private Date endDate;

    private String couponName;

    private String couponCode;

    private String couponDefinitionId;

    /**
     * 转赠人手机号
     */
    private String givePhone;

    /**
     * 受赠人手机号
     */
    private String receivePhone;

    /**
     * 类型 1: 转增 2: 受赠 3: 转赠撤回
     */
    private Integer transferType;

    /**
     * 转赠人memberCode
     */
    private String giveMemberCode;

}
