package com.bizvane.couponfacade.interfaces;

import com.bizvane.couponfacade.models.vo.standard.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @author xz
 * @date 2020/3/5 10:09
 **/

@FeignClient(value="${feign.client.coupon.name}",path="${feign.client.coupon.path}/standardCouponRpc")
@Api(value = "标准券接口",tags = {"标准券接口"})
public interface StandardCouponServiceFeign {

    @ApiOperation(value = "优惠券核销", notes = "优惠券核销", tags = {"标准接口"},httpMethod = "POST")
    @RequestMapping(value = "/couponUse", method = RequestMethod.POST)
    ResponseData<String> couponUse(StandardCouponUseRequestVo standardCouponUseRequestVo);

    @ApiOperation(value = "优惠券实体对象查询", notes = "优惠券实体对象查询", tags = {"标准接口"},httpMethod = "POST")
    @RequestMapping(value = "/getMbrCouponEntity", method = RequestMethod.POST)
    ResponseData<StandardCouponEntityResponseVo> getMbrCouponEntity(StandardCouponEntityRequestVo standardCouponEntityRequestVo);

    @ApiOperation(value = "优惠券定义新增", notes = "优惠券定义新增", tags = {"标准接口"},httpMethod = "POST")
    @RequestMapping(value = "/couponDefinitionAdd", method = RequestMethod.POST)
    ResponseData<String> couponDefinitionAdd(@RequestBody StandardCouponDefinitionAddVo standardCouponDefinitionAddVo);

    @ApiOperation(value = "优惠券实体新增", notes = "优惠券实体新增", tags = {"标准接口"},httpMethod = "POST")
    @RequestMapping(value = "/couponEntityAdd", method = RequestMethod.POST)
    ResponseData<String> couponEntityAdd(@RequestBody StandardCouponEntityAddVo standardCouponEntityAddVo);

    @ApiOperation(value = "优惠券实体批量新增", notes = "优惠券实体批量新增", tags = {"标准接口"},httpMethod = "POST")
    @RequestMapping(value = "/couponEntityBatchAdd", method = RequestMethod.POST)
    ResponseData<String> couponEntityBatchAdd(@RequestBody List<StandardCouponEntityAddVo> standardCouponEntityAddVoList);

}
