package com.bizvane.couponfacade.models.vo.standard;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zcc
 * @date 2021/3/9 13:57
 **/
@Data
public class StandardCouponEntityResponseVo implements Serializable {
    private static final long serialVersionUID = -7971576503438773594L;

    /**
     * 品牌code
     */
    private String brandCode;
    /**
     * 券code
     */
    private String couponCode;
    /**
     * 券名称
     */
    private String couponName;
    /**
     * 券类型（1现金，2折扣，3礼品）
     */
    private Integer preferentialType;
    /**
     * 会员code
     */
    private String memberCode;
    /**
     * 券有效开日期
     */
    private Date validDateStart;
    /**
     * 券有效结束日期
     */
    private Date validDateEnd;
    /**
     * 券面额
     */
    private String money;
    /**
     * 券折扣
     */
    private String discount;
    /**
     * 券描述
     */
    private String info;
    /**
     * 券使用类型 :1.线上 2.线下
     */
    private Integer useType;
    /**
     * 使用门店code
     */
    private String useStoreCode;
    /**
     * 使用订单号
     */
    private String useBusinessOrder;
    /**
     * 使用时间
     */
    private String useTime;
    /**
     * 券状态:20.未使用,25:已过,30:已核销
     */
    private Integer couponStatus;
    /**
     * 是否使用:true:已使用 false:未使用
     */
    private Boolean isUse;
    /**
     * 转增状态:true:已转增 false:未转赠
     */
    private Boolean give;


}
