package com.bizvane.core.facade.models.vo;

import com.alibaba.fastjson.JSON;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

@Data
public class SysActionLogVO implements Serializable {

    private Long actionLogId;

    @NotNull(message = "企业id不能为空")
    private Long sysCompanyId;

    @NotNull(message = "品牌id不能为空")
    private Long sysBrandId;


    private String account;


    private Long actionLogConfigId;
    //标识
    @NotBlank(message = "标识不能为空")
    private String mark;

    //操作类型 1:新增,:2修改,3:删除...
    @NotNull(message = "操作类型不能为空")
    private Byte operationType;
    //解析json
    private String voJson;


    private String traceid;


    private String ipAddress;


    private String controllerUrl;


    private String contentType;


    private String applicationName;


    private String requestSource;


    private String requestMethod;


    private String buttonCode;


    private String buttonName;

    private String menuParentCode;

    private String menuCode;


    private String menuName;


    private String webhtmlUrl;


    private Boolean valid;


    private Long createUserId;


    private Date createDate;


    private String createUserName;


    private Long modifiedUserId;


    private String modifiedUserName;


    private Date modifiedDate;


    private String logContent;

    private JSON logContentJson;

    private Date startDate;

    private Date endDate;

    private JSON showJson;
    private String showJsonStr;


    private static final long serialVersionUID = 1L;


    }