package com.bizvane.core.facade.interfaces;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.core.facade.interfaces.feign.SysActionLogServiceFeign;
import com.bizvane.core.facade.models.vo.SysActionLogVO;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.jboss.logging.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.net.URLDecoder;
import java.util.Date;

@Component
@Slf4j
public class SysCommonActionLogService {
    @Autowired
    private HttpServletRequest request;
//    @Autowired
//    private Tracing tracing;
    @Value("${spring.application.name}")
    private String appName;

    @Autowired(required = false)
    private SysActionLogServiceFeign sysActionLogServiceFeign;

    private static final String TRACE_ID = "traceId";

    /**
     *
     * @param content 日志内容
     * @param operationType 操作类型 1:新增,:2修改,3:删除
     * @param mark 标识
     */
    public void collect(String content,Byte operationType ,String mark){
        log.info("接受参数content:{},operationType:{},mark:{}",content,operationType,mark);
        SysActionLogVO sysActionLogVO = new SysActionLogVO();
        sysActionLogVO.setApplicationName(appName);
        sysActionLogVO.setCreateDate(new Date());
        sysActionLogVO.setLogContent(content);
        sysActionLogVO.setOperationType(operationType);
        sysActionLogVO.setMark(mark);
        Object o = MDC.get(TRACE_ID);
        if(o != null && o instanceof String){
            sysActionLogVO.setTraceid((String) o);
        }
        String ipAddress = getIpAddress(request);
        sysActionLogVO.setIpAddress(ipAddress);
        sysActionLogVO.setControllerUrl(request.getRequestURL().toString());
        sysActionLogVO.setRequestMethod(request.getMethod());
        sysActionLogVO.setContentType(request.getHeader("Content-Type"));

        String sysLogJson = request.getHeader("bizvaneLogs");
        JSONObject jsonObject = decrypt(sysLogJson);
        if(jsonObject != null){
            String source = (String) jsonObject.get("source");
            sysActionLogVO.setRequestSource(source);
            if("crm".equals(source)){
                SysAccountPO stageUser = TokenUtils.getStageUser(request);
                if(stageUser != null){
                    sysActionLogVO.setAccount(stageUser.getAccountCode());
                    sysActionLogVO.setCreateUserId(stageUser.getSysAccountId());
                    sysActionLogVO.setCreateUserName(stageUser.getName());
                    sysActionLogVO.setSysCompanyId(stageUser.getSysCompanyId());
                    sysActionLogVO.setSysBrandId(stageUser.getBrandId());
                }
            }
            sysActionLogVO.setButtonCode((String) jsonObject.get("buttonCode"));
            sysActionLogVO.setButtonName((String) jsonObject.get("buttonName"));
            sysActionLogVO.setMenuCode((String) jsonObject.get("menuCode"));
            sysActionLogVO.setMenuName((String) jsonObject.get("menuName"));
            sysActionLogVO.setWebhtmlUrl((String) jsonObject.get("webhtmlUrl"));
            log.info("收集日志SysActionLogVO:{}",JSONObject.toJSONString(sysActionLogVO));
            log.info("开始调用sysActionLogServiceFeign");
            invoking(sysActionLogVO);
        }

    }
    @Async
    public void invoking(SysActionLogVO sysActionLogVO){
        if(sysActionLogServiceFeign != null){
            sysActionLogServiceFeign.insert(sysActionLogVO);
        }
    }

    private String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private JSONObject decrypt(String vString){
        String decode = null;
        if(vString == null){
            return null;
        }
        try {
            decode = URLDecoder.decode(vString, "UTF-8");
            if(StringUtil.isBlank(decode)){
                return null;
            }
            Object parse = JSON.parse(decode);
            if(parse instanceof JSONObject){
                return (JSONObject) parse;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return  null;
        }
        return null;
    }

}
