/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.core.facade.interfaces;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.core.facade.interfaces.feign.SysActionLogServiceFeign;
import com.bizvane.core.facade.models.vo.SysActionLogVO;
import com.bizvane.utils.tokens.CtrlAccountPO;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import java.net.URLDecoder;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import jodd.util.StringUtil;
import org.jboss.logging.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class SysCommonActionLogService {
    private static final Logger log = LoggerFactory.getLogger(SysCommonActionLogService.class);
    @Autowired
    private HttpServletRequest request;
    @Value(value="${spring.application.name}")
    private String appName;
    @Autowired(required=false)
    private SysActionLogServiceFeign sysActionLogServiceFeign;
    private static final String TRACE_ID = "traceId";

    public void collect(String content, Byte operationType, String mark) {
        log.info("\u63a5\u53d7\u53c2\u6570content:{},operationType:{},mark:{}", new Object[]{content, operationType, mark});
        SysActionLogVO sysActionLogVO = new SysActionLogVO();
        sysActionLogVO.setApplicationName(this.appName);
        sysActionLogVO.setCreateDate(new Date());
        sysActionLogVO.setLogContent(content);
        sysActionLogVO.setOperationType(operationType);
        sysActionLogVO.setMark(mark);
        Object o = MDC.get((String)TRACE_ID);
        if (o != null && o instanceof String) {
            sysActionLogVO.setTraceid((String)o);
        }
        String ipAddress = this.getIpAddress(this.request);
        sysActionLogVO.setIpAddress(ipAddress);
        sysActionLogVO.setControllerUrl(this.request.getRequestURL().toString());
        sysActionLogVO.setRequestMethod(this.request.getMethod());
        sysActionLogVO.setContentType(this.request.getHeader("Content-Type"));
        String sysLogJson = this.request.getHeader("bizvaneLogs");
        JSONObject jsonObject = this.decrypt(sysLogJson);
        if (jsonObject != null) {
            CtrlAccountPO ctrlAccountPO;
            String source = (String)jsonObject.get((Object)"source");
            sysActionLogVO.setRequestSource(source);
            if ("crm".equals(source)) {
                SysAccountPO stageUser = TokenUtils.getStageUser((HttpServletRequest)this.request);
                if (stageUser != null) {
                    sysActionLogVO.setAccount(stageUser.getAccountCode());
                    sysActionLogVO.setCreateUserId(stageUser.getSysAccountId());
                    sysActionLogVO.setCreateUserName(stageUser.getName());
                    sysActionLogVO.setSysCompanyId(stageUser.getSysCompanyId());
                    sysActionLogVO.setSysBrandId(stageUser.getBrandId());
                }
            } else if ("centercontrol".equals(source) && (ctrlAccountPO = TokenUtils.getControlUser((HttpServletRequest)this.request)) != null) {
                sysActionLogVO.setAccount(ctrlAccountPO.getAccountCode());
                sysActionLogVO.setCreateUserId(ctrlAccountPO.getCtrlAccountId());
                sysActionLogVO.setCreateUserName(ctrlAccountPO.getName());
            }
            sysActionLogVO.setButtonCode((String)jsonObject.get((Object)"buttonCode"));
            sysActionLogVO.setButtonName((String)jsonObject.get((Object)"buttonName"));
            sysActionLogVO.setMenuCode((String)jsonObject.get((Object)"menuCode"));
            sysActionLogVO.setMenuName((String)jsonObject.get((Object)"menuName"));
            sysActionLogVO.setWebhtmlUrl((String)jsonObject.get((Object)"webhtmlUrl"));
            log.info("\u6536\u96c6\u65e5\u5fd7SysActionLogVO:{}", (Object)JSONObject.toJSONString((Object)sysActionLogVO));
            log.info("\u5f00\u59cb\u8c03\u7528sysActionLogServiceFeign");
            this.invoking(sysActionLogVO);
        }
    }

    public void commonCollect(String content, Byte operationType, String mark, HttpServletRequest request) {
        log.info("\u63a5\u53d7\u53c2\u6570content:{},operationType:{},mark:{}", new Object[]{content, operationType, mark});
        SysActionLogVO sysActionLogVO = new SysActionLogVO();
        sysActionLogVO.setApplicationName(this.appName);
        sysActionLogVO.setCreateDate(new Date());
        sysActionLogVO.setLogContent(content);
        sysActionLogVO.setOperationType(operationType);
        sysActionLogVO.setMark(mark);
        Object o = MDC.get((String)TRACE_ID);
        if (o != null && o instanceof String) {
            sysActionLogVO.setTraceid((String)o);
        }
        String ipAddress = this.getIpAddress(request);
        sysActionLogVO.setIpAddress(ipAddress);
        sysActionLogVO.setControllerUrl(request.getRequestURL().toString());
        sysActionLogVO.setRequestMethod(request.getMethod());
        sysActionLogVO.setContentType(request.getHeader("Content-Type"));
        String sysLogJson = request.getHeader("bizvaneLogs");
        JSONObject jsonObject = this.decrypt(sysLogJson);
        if (jsonObject != null) {
            CtrlAccountPO ctrlAccountPO;
            String source = (String)jsonObject.get((Object)"source");
            sysActionLogVO.setRequestSource(source);
            if ("crm".equals(source)) {
                SysAccountPO stageUser = TokenUtils.getStageUser((HttpServletRequest)request);
                if (stageUser != null) {
                    sysActionLogVO.setAccount(stageUser.getAccountCode());
                    sysActionLogVO.setCreateUserId(stageUser.getSysAccountId());
                    sysActionLogVO.setCreateUserName(stageUser.getName());
                    sysActionLogVO.setSysCompanyId(stageUser.getSysCompanyId());
                    sysActionLogVO.setSysBrandId(stageUser.getBrandId());
                }
            } else if ("centercontrol".equals(source) && (ctrlAccountPO = TokenUtils.getControlUser((HttpServletRequest)request)) != null) {
                sysActionLogVO.setAccount(ctrlAccountPO.getAccountCode());
                sysActionLogVO.setCreateUserId(ctrlAccountPO.getCtrlAccountId());
                sysActionLogVO.setCreateUserName(ctrlAccountPO.getName());
            }
            sysActionLogVO.setButtonCode((String)jsonObject.get((Object)"buttonCode"));
            sysActionLogVO.setButtonName((String)jsonObject.get((Object)"buttonName"));
            sysActionLogVO.setMenuCode((String)jsonObject.get((Object)"menuCode"));
            sysActionLogVO.setMenuName((String)jsonObject.get((Object)"menuName"));
            sysActionLogVO.setWebhtmlUrl((String)jsonObject.get((Object)"webhtmlUrl"));
            log.info("\u6536\u96c6\u65e5\u5fd7SysActionLogVO:{}", (Object)JSONObject.toJSONString((Object)sysActionLogVO));
            log.info("\u5f00\u59cb\u8c03\u7528sysActionLogServiceFeign");
            this.invoking(sysActionLogVO);
        }
    }

    @Async
    public void invoking(SysActionLogVO sysActionLogVO) {
        if (this.sysActionLogServiceFeign != null) {
            this.sysActionLogServiceFeign.insert(sysActionLogVO);
        }
    }

    private String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private JSONObject decrypt(String vString) {
        String decode = null;
        if (vString == null) {
            return null;
        }
        try {
            decode = URLDecoder.decode(vString, "UTF-8");
            if (StringUtil.isBlank((CharSequence)decode)) {
                return null;
            }
            Object parse = JSON.parse((String)decode);
            if (parse instanceof JSONObject) {
                return (JSONObject)parse;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }
}

