package com.bizvane.core.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 会员生命周期参数
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_lifecycle_parameter")
public class MemberLifecycleParameterModel extends BaseModel implements Serializable {

	private static final long serialVersionUID = -1002246021303066367L;

	@Id
	@ApiModelProperty(value = "生命周期参数id", name = "mbrLifecycleParameterId")
	private Long mbrLifecycleParameterId;
	@ApiModelProperty(value = "企业id", name = "sysCompanyId")
	private Long sysCompanyId;
	@ApiModelProperty(value = "品牌id", name = "brandId")
	private Long brandId;
	@ApiModelProperty(value = "新会员", name = "new_member")
	private Integer newMember;
	@ApiModelProperty(value = "活跃会员", name = "active_member")
	private Integer activeMember;
	@ApiModelProperty(value = "沉默会员", name = "silence_member")
	private Integer silenceMember;
	@ApiModelProperty(value = "濒临睡眠会员", name = "closeto_sleep_member")
	private Integer closetoSleepMember;
	@ApiModelProperty(value = "休眠会员", name = "sleep_member")
	private Integer sleepMember;
}