package com.bizvane.core.facade.interfaces;

import com.bizvane.core.facade.models.po.TracePO;
import com.bizvane.core.facade.models.po.TraceRecordPO;
import com.bizvane.core.facade.models.vo.TraceRecordVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

@FeignClient(value="${feign.client.core.name}",path="${feign.client.core.path}/coreTrace")
@Api(value = "Trace接口",tags = {"Trace接口"})
public interface CoreTraceFeign {

	@ApiOperation(value = "新增trace")
	@PostMapping(value = "/insertTrace")
	ResponseData<Long> insertTrace(TracePO vo);


	@ApiOperation(value = "查询trace")
	@PostMapping(value = "/selectByTraceId")
	ResponseData<TracePO> selectByTraceId(Long traceId);


	@ApiOperation(value = "根据traceId插入一条trace记录")
	@PostMapping(value = "/saveTraceRecord")
	ResponseData saveTraceRecord(TraceRecordVo vo);


	@ApiOperation(value = "根据unionid查询最近一条trace记录")
	@PostMapping(value = "/selectTraceRecord")
	ResponseData<TraceRecordPO> selectTraceRecord(TraceRecordVo vo);
}
