package com.bizvane.core.facade.es.pojo;

import java.io.Serializable;
import java.util.Date;

import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;

import com.fasterxml.jackson.annotation.JsonFormat;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode
@Document(indexName = "t_mbr_members", type = "doc")
public class MembersGroupAnalyzePojo implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	// polarDB mbr主键id
	@Id
	private Long mbrMemberId;
	// 会员code
	private String memberCode;
	// 线下品牌id
	private String offlineBrandCode;
	// 线下会员id
	private String vipId;
	// 国家
	private String county;
	// 省份
	private String province;
	// 市
	private String city;
	// 生日
	@JsonFormat(pattern="yyyy-MM-dd")
	private Date birthday;
	// 等级id(线上)
	private Long levelId;
	// 线下等级code
	private String offlineLevelCode;
	// 性别
	private String gender;
	// 开卡天数
	private int newMember;
	// 会员活跃度
	private String memberLiveness;
	// 累计消费金额
	private String consumeAmountAll;
	// 是否为新会员: 1=新会员; 2=老会员
	private Integer groupNewMember;
	
	private long serviceStoreId;

	private String birthdayMd;

}
